/*
 * Copyright 2009 JBoss, a divison Red Hat, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.errai.bus.server;

import org.jboss.errai.bus.client.api.base.MessageDeliveryFailure;

/**
 * <tt>NoSubscribersToDeliverTo</tt> extends the <tt>RuntimeException</tt>. It is thrown when there is no where to
 * deliver a message to
 */
public class NoSubscribersToDeliverTo extends MessageDeliveryFailure {
    private static final long serialVersionUID = -5385972750788483158L;

    public NoSubscribersToDeliverTo() {
        super();
    }

    public NoSubscribersToDeliverTo(String message) {
        super(message);
    }

    public NoSubscribersToDeliverTo(String message, Throwable cause) {
        super(message, cause);    
    }

    public NoSubscribersToDeliverTo(Throwable cause) {
        super(cause);
    }
}
