/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.pvm.internal.cmd;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.jbpm.api.JbpmException;
import org.jbpm.api.cmd.Environment;
import org.jbpm.pvm.internal.history.model.HistoryProcessInstanceImpl;
import org.jbpm.pvm.internal.history.model.HistoryVariableImpl;
import org.jbpm.pvm.internal.session.DbSession;

/**
 * @author Maciej Swiderski
 */
public class GetHistoryVariablesCmd extends AbstractCommand<Map<String, ?>> {

  private static final long serialVersionUID = 1L;

  protected String processInstanceId;
  protected Set<String> variableNames;

  public GetHistoryVariablesCmd(String processInstanceId, Set<String> variableNames) {
    if (processInstanceId == null) {
      throw new JbpmException("processInstanceId is null");
    }
    if (variableNames == null) {
      throw new JbpmException("variableNames is null");
    }
    this.processInstanceId = processInstanceId;
    this.variableNames = variableNames;
  }

  public Map<String, ?> execute(Environment environment) throws Exception {
    HistoryProcessInstanceImpl historyProcessInstance = (HistoryProcessInstanceImpl) environment.get(DbSession.class)
      .createHistoryProcessInstanceQuery()
      .processInstanceId(processInstanceId)
      .uniqueResult();
    if (historyProcessInstance == null) {
      throw new JbpmException("process instance not found in history: " + processInstanceId);
    }

    Map<String, Object> variableMap = new HashMap<String, Object>();
    for (HistoryVariableImpl historyVariable : historyProcessInstance.getHistoryVariables()) {
      if (variableNames.contains(historyVariable.getVariableName())) {
        variableMap.put(historyVariable.getVariableName(), historyVariable.getValue());
      }
    }

    return variableMap;
  }

}
