/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.juel;

import com.sun.script.juel.JuelScriptEngineFactory;
import de.odysseus.el.util.SimpleResolver;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.ResourceBundleELResolver;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

public class JuelScriptEngine
extends AbstractScriptEngine
implements Compilable {
    private ScriptEngineFactory factory;
    private ExpressionFactory exprFactory;

    public JuelScriptEngine(ScriptEngineFactory factory) {
        this.factory = factory;
        this.exprFactory = ExpressionFactory.newInstance();
    }

    public JuelScriptEngine() {
        this((ScriptEngineFactory)null);
    }

    public CompiledScript compile(String script) throws ScriptException {
        ValueExpression expr = this.parse(script, this.context);
        return new JuelCompiledScript(expr);
    }

    public CompiledScript compile(Reader reader) throws ScriptException {
        return this.compile(this.readFully(reader));
    }

    public Object eval(String script, ScriptContext ctx) throws ScriptException {
        ValueExpression expr = this.parse(script, ctx);
        return this.evalExpr(expr, ctx);
    }

    public Object eval(Reader reader, ScriptContext ctx) throws ScriptException {
        return this.eval(this.readFully(reader), ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptEngineFactory getFactory() {
        JuelScriptEngine juelScriptEngine = this;
        synchronized (juelScriptEngine) {
            if (this.factory == null) {
                this.factory = new JuelScriptEngineFactory();
            }
        }
        return this.factory;
    }

    public Bindings createBindings() {
        return new SimpleBindings();
    }

    private ELContext toELContext(ScriptContext ctx) {
        Object tmp = ctx.getAttribute("elcontext");
        if (tmp instanceof ELContext) {
            return (ELContext)tmp;
        }
        ctx.setAttribute("context", ctx, 100);
        ctx.setAttribute("out:print", JuelScriptEngine.getPrintMethod(), 100);
        SecurityManager manager = System.getSecurityManager();
        if (manager == null) {
            ctx.setAttribute("lang:import", JuelScriptEngine.getImportMethod(), 100);
        }
        ELContext elContext = new ELContext(ctx){
            ELResolver resolver;
            VariableMapper varMapper;
            FunctionMapper funcMapper;
            {
                this.resolver = JuelScriptEngine.this.makeResolver();
                this.varMapper = new ScriptContextVariableMapper(scriptContext);
                this.funcMapper = new ScriptContextFunctionMapper(scriptContext);
            }

            public ELResolver getELResolver() {
                return this.resolver;
            }

            public VariableMapper getVariableMapper() {
                return this.varMapper;
            }

            public FunctionMapper getFunctionMapper() {
                return this.funcMapper;
            }
        };
        ctx.setAttribute("elcontext", elContext, 100);
        return elContext;
    }

    private ELResolver makeResolver() {
        CompositeELResolver chain = new CompositeELResolver();
        chain.add((ELResolver)new ArrayELResolver());
        chain.add((ELResolver)new ListELResolver());
        chain.add((ELResolver)new MapELResolver());
        chain.add((ELResolver)new ResourceBundleELResolver());
        chain.add((ELResolver)new BeanELResolver());
        return new SimpleResolver((ELResolver)chain);
    }

    private ValueExpression parse(String script, ScriptContext ctx) throws ScriptException {
        try {
            return this.exprFactory.createValueExpression(this.toELContext(ctx), script, Object.class);
        }
        catch (ELException elexp) {
            throw new ScriptException((Exception)((Object)elexp));
        }
    }

    private Object evalExpr(ValueExpression expr, ScriptContext ctx) throws ScriptException {
        try {
            return expr.getValue(this.toELContext(ctx));
        }
        catch (ELException elexp) {
            throw new ScriptException((Exception)((Object)elexp));
        }
    }

    private String readFully(Reader reader) throws ScriptException {
        char[] arr = new char[8192];
        StringBuilder buf = new StringBuilder();
        try {
            int numChars;
            while ((numChars = reader.read(arr, 0, arr.length)) > 0) {
                buf.append(arr, 0, numChars);
            }
        }
        catch (IOException exp) {
            throw new ScriptException(exp);
        }
        return buf.toString();
    }

    private static Method getPrintMethod() {
        try {
            Class<JuelScriptEngine> myClass = JuelScriptEngine.class;
            Method method = myClass.getMethod("print", Object.class);
            return method;
        }
        catch (Exception exp) {
            return null;
        }
    }

    public static void print(Object obj) {
        System.out.print(obj);
    }

    private static Method getImportMethod() {
        try {
            Class<JuelScriptEngine> myClass = JuelScriptEngine.class;
            Method method = myClass.getMethod("importFunctions", ScriptContext.class, String.class, Object.class);
            return method;
        }
        catch (Exception exp) {
            return null;
        }
    }

    public static void importFunctions(ScriptContext ctx, String namespace, Object obj) {
        Method[] methods;
        Class<?> clazz = null;
        if (obj instanceof Class) {
            clazz = (Class<?>)obj;
        } else if (obj instanceof String) {
            try {
                clazz = Class.forName((String)obj);
            }
            catch (ClassNotFoundException cnfe) {
                throw new ELException((Throwable)cnfe);
            }
        } else {
            throw new ELException("Class or class name is missing");
        }
        Method[] methodArray = methods = clazz.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            int mod = m.getModifiers();
            if (Modifier.isStatic(mod) && Modifier.isPublic(mod)) {
                String name = String.valueOf(namespace) + ":" + m.getName();
                ctx.setAttribute(name, m, 100);
            }
            ++n2;
        }
    }

    private class JuelCompiledScript
    extends CompiledScript {
        private ValueExpression expr;

        JuelCompiledScript(ValueExpression expr) {
            this.expr = expr;
        }

        public ScriptEngine getEngine() {
            return JuelScriptEngine.this;
        }

        public Object eval(ScriptContext ctx) throws ScriptException {
            return JuelScriptEngine.this.evalExpr(this.expr, ctx);
        }
    }

    private class ScriptContextFunctionMapper
    extends FunctionMapper {
        private ScriptContext ctx;

        ScriptContextFunctionMapper(ScriptContext ctx) {
            this.ctx = ctx;
        }

        private String getFullName(String prefix, String localName) {
            return String.valueOf(prefix) + ":" + localName;
        }

        public Method resolveFunction(String prefix, String localName) {
            String fullName = this.getFullName(prefix, localName);
            int scope = this.ctx.getAttributesScope(fullName);
            if (scope != -1) {
                Object tmp = this.ctx.getAttribute(fullName);
                return tmp instanceof Method ? (Method)tmp : null;
            }
            return null;
        }
    }

    private class ScriptContextVariableMapper
    extends VariableMapper {
        private ScriptContext ctx;

        ScriptContextVariableMapper(ScriptContext ctx) {
            this.ctx = ctx;
        }

        public ValueExpression resolveVariable(String variable) {
            int scope = this.ctx.getAttributesScope(variable);
            if (scope != -1) {
                Object value = this.ctx.getAttribute(variable, scope);
                if (value instanceof ValueExpression) {
                    return (ValueExpression)value;
                }
                return JuelScriptEngine.this.exprFactory.createValueExpression(value, Object.class);
            }
            return null;
        }

        public ValueExpression setVariable(String variable, ValueExpression value) {
            ValueExpression oldValue = this.resolveVariable(variable);
            this.ctx.setAttribute(variable, value, 100);
            return oldValue;
        }
    }
}

