/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn.flownodes;

import java.util.List;
import org.jbpm.bpmn.flownodes.BpmnBinding;
import org.jbpm.bpmn.flownodes.NoneStartEventActivity;
import org.jbpm.bpmn.flownodes.TimerStartEventActivity;
import org.jbpm.bpmn.model.BpmnProcessDefinition;
import org.jbpm.bpmn.parser.BpmnParser;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.job.StartProcessTimer;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.TimerDefinitionImpl;
import org.jbpm.pvm.internal.session.DbSession;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.xml.Parse;
import org.w3c.dom.Element;

public class StartEventBinding
extends BpmnBinding {
    private static final Log LOG = Log.getLog((String)StartEventBinding.class.getName());

    public StartEventBinding() {
        super("startEvent");
    }

    public Object parse(Element element, Parse parse, BpmnParser bpmnParser) {
        ActivityImpl startActivity = (ActivityImpl)parse.contextStackFind(ActivityImpl.class);
        BpmnProcessDefinition processDefinition = (BpmnProcessDefinition)((Object)parse.contextStackFind(BpmnProcessDefinition.class));
        if (processDefinition.getInitial() == null) {
            processDefinition.setInitial(startActivity);
        } else if (startActivity.getParentActivity() == null) {
            parse.addProblem("multiple start events not yet supported", element);
        }
        String id = XmlUtil.attribute((Element)element, (String)"id", (Parse)parse);
        Element eventDefinition = XmlUtil.element((Element)element);
        if (eventDefinition != null && "timerEventDefinition".equals(eventDefinition.getNodeName())) {
            return this.createTimerStartEvent(processDefinition, eventDefinition, id, bpmnParser, parse);
        }
        if (eventDefinition != null) {
            parse.addProblem("Invalid eventDefinition type : " + eventDefinition.getNodeName());
        }
        return new NoneStartEventActivity();
    }

    protected TimerStartEventActivity createTimerStartEvent(BpmnProcessDefinition processDefinition, Element timerEventDefinition, String eventId, BpmnParser parser, Parse parse) {
        TimerStartEventActivity timerStartEvent = new TimerStartEventActivity();
        TimerDefinitionImpl timerDefinition = parser.parseTimerEventDefinition(timerEventDefinition, parse, eventId);
        if (timerDefinition == null) {
            return null;
        }
        StartProcessTimer startProcessTimer = new StartProcessTimer();
        startProcessTimer.setProcessDefinitionName(processDefinition.getName());
        if (timerDefinition.getDueDate() != null) {
            startProcessTimer.setDuedate(timerDefinition.getDueDate());
        } else if (timerDefinition.getDueDateDescription() != null) {
            startProcessTimer.setIntervalExpression(timerDefinition.getDueDateDescription());
        } else if (timerDefinition.getCronExpression() != null) {
            startProcessTimer.setIntervalExpression(timerDefinition.getCronExpression());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scheduling a new start process timer for process definition " + processDefinition.getName());
        }
        this.deleteStartProcessTimers(processDefinition.getName());
        startProcessTimer.schedule();
        return timerStartEvent;
    }

    protected void deleteStartProcessTimers(String processDefinitionName) {
        DbSession dbSession = (DbSession)EnvironmentImpl.getCurrent().get(DbSession.class);
        List existingTimers = dbSession.findStartProcessTimers(processDefinitionName);
        for (StartProcessTimer spt : existingTimers) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Removing existing start process timer: " + spt);
            }
            dbSession.delete((Object)spt);
        }
    }
}

