/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn.flownodes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jbpm.api.JbpmException;
import org.jbpm.api.activity.ActivityBehaviour;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.api.model.Activity;
import org.jbpm.api.model.OpenExecution;
import org.jbpm.api.model.Transition;
import org.jbpm.bpmn.flownodes.ActivityResource;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.Condition;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.TransitionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BpmnActivity
implements ActivityBehaviour {
    private static final Log LOG = Log.getLog((String)BpmnActivity.class.getName());
    private static final long serialVersionUID = 1L;
    protected static final boolean CONDITIONS_CHECKED = true;
    protected static final boolean CONDITIONS_IGNORED = false;
    protected String default_;
    protected List<ActivityResource> activityResources = new ArrayList<ActivityResource>();

    public void execute(ActivityExecution execution) throws Exception {
        this.execute((ExecutionImpl)execution);
    }

    public abstract void execute(ExecutionImpl var1);

    protected void proceed(ExecutionImpl execution, List<Transition> transitions) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Proceeding from execution in " + execution.getActivityName());
        }
        ActivityImpl activity = execution.getActivity();
        if (transitions.size() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No outgoing transitions found. Ending the execution");
            }
            execution.end();
        } else if (transitions.size() == 1) {
            execution.take(transitions.get(0));
        } else {
            ExecutionImpl concurrentRoot = null;
            if ("active-root".equals(execution.getState())) {
                concurrentRoot = execution;
                execution.setState("inactive-concurrent-root");
                execution.setActivity(null);
            } else if ("active-concurrent".equals(execution.getState())) {
                concurrentRoot = execution.getParent();
                execution.end();
            }
            HashMap<Transition, ExecutionImpl> childExecutionsMap = new HashMap<Transition, ExecutionImpl>();
            for (Transition transition : transitions) {
                ExecutionImpl concurrentExecution = concurrentRoot.createExecution(transition.getName());
                concurrentExecution.setActivity((Activity)activity);
                concurrentExecution.setState("active-concurrent");
                childExecutionsMap.put(transition, concurrentExecution);
            }
            for (Transition transition : childExecutionsMap.keySet()) {
                ((ExecutionImpl)childExecutionsMap.get(transition)).take(transition);
                if (!concurrentRoot.isEnded()) continue;
                break;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<Transition> findOutgoingSequenceFlow(ExecutionImpl execution, boolean checkConditions) {
        ActivityImpl activity = execution.getActivity();
        ArrayList<Transition> forkingTransitions = new ArrayList<Transition>();
        List outgoingTransitions = activity.getOutgoingTransitions();
        for (TransitionImpl transition : outgoingTransitions) {
            Condition condition = transition.getCondition();
            if (condition != null && checkConditions && !condition.evaluate((OpenExecution)execution) || activity.getDefaultOutgoingTransition() == transition) continue;
            forkingTransitions.add((Transition)transition);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(forkingTransitions.size() + " out of " + outgoingTransitions.size() + " selected for " + activity.getName());
        }
        if (forkingTransitions.isEmpty() && this.isDefaultEnabled()) {
            TransitionImpl defaultSeqFlow = execution.getActivity().getDefaultOutgoingTransition();
            if (defaultSeqFlow == null) throw new JbpmException("No sequence flow condition evaluated to true for " + execution.getActivityName() + " and no default sequenceFlow was speficied");
            forkingTransitions.add((Transition)defaultSeqFlow);
            if (!LOG.isDebugEnabled()) return forkingTransitions;
            LOG.debug("Selected default sequence flow for " + execution.getActivityName());
            return forkingTransitions;
        } else {
            if (!forkingTransitions.isEmpty()) return forkingTransitions;
            throw new JbpmException("No outgoing sequence flow found for " + execution.getActivityName());
        }
    }

    public void addActivityResource(ActivityResource activityResource) {
        this.activityResources.add(activityResource);
    }

    public boolean isDefaultEnabled() {
        return true;
    }

    public String getDefault() {
        return this.default_;
    }

    public void setDefault(String default_) {
        this.default_ = default_;
    }
}

