/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.timer.transition;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.job.Job;
import org.jbpm.test.JbpmTestCase;

public class TimerTransitionTest
extends JbpmTestCase {
    String deploymentId;

    protected void setUp() throws Exception {
        super.setUp();
        this.deploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/examples/timer/transition/process.jpdl.xml").deploy();
    }

    protected void tearDown() throws Exception {
        this.repositoryService.deleteDeploymentCascade(this.deploymentId);
        super.tearDown();
    }

    public void testTimerTransitionTimerFires() {
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("TimerTransition");
        Job job = this.managementService.createJobQuery().timers().processInstanceId(processInstance.getId()).uniqueResult();
        this.managementService.executeJob(job.getId());
        processInstance = this.executionService.findProcessInstanceById(processInstance.getId());
        TimerTransitionTest.assertTrue((boolean)processInstance.isActive("escalation"));
    }

    public void testTimerTransitionContinueBeforeTimerFires() {
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("TimerTransition");
        String executionId = processInstance.findActiveExecutionIn("guardedWait").getId();
        this.executionService.signalExecutionById(executionId, "go on");
        processInstance = this.executionService.findProcessInstanceById(processInstance.getId());
        TimerTransitionTest.assertTrue((boolean)processInstance.isActive("next step"));
        List jobs = this.managementService.createJobQuery().processInstanceId(processInstance.getId()).list();
        TimerTransitionTest.assertEquals(new ArrayList(), new ArrayList(jobs));
    }
}

