/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.decision.conditions;

import java.util.HashMap;
import org.jbpm.api.ProcessInstance;
import org.jbpm.test.JbpmTestCase;

public class DecisionConditionsTest
extends JbpmTestCase {
    String deploymentId;

    protected void setUp() throws Exception {
        super.setUp();
        this.deploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/examples/decision/conditions/process.jpdl.xml").deploy();
    }

    protected void tearDown() throws Exception {
        this.repositoryService.deleteDeploymentCascade(this.deploymentId);
        super.tearDown();
    }

    public void testDecisionConditionsGood() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("content", "good");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("DecisionConditions", variables);
        DecisionConditionsTest.assertTrue((boolean)processInstance.isActive("submit document"));
    }

    public void testDecisionConditionsBad() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("content", "bad");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("DecisionConditions", variables);
        DecisionConditionsTest.assertTrue((boolean)processInstance.isActive("try again"));
    }

    public void testDecisionConditionsUgly() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("content", "ugly");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("DecisionConditions", variables);
        DecisionConditionsTest.assertTrue((boolean)processInstance.isActive("give up"));
    }
}

