/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.concurrency.foreach;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;

public class ForEachTest
extends JbpmTestCase {
    String deploymentId;
    String deptSales;
    String deptHR;
    String deptFinance;

    protected void setUp() throws Exception {
        super.setUp();
        this.deptSales = this.identityService.createGroup("sales-dept");
        this.deptHR = this.identityService.createGroup("hr-dept");
        this.deptFinance = this.identityService.createGroup("finance-dept");
        this.identityService.createUser("johndoe", "John", "Doe");
        this.identityService.createMembership("johndoe", this.deptSales, "SalesManager");
        this.identityService.createUser("joesmoe", "Joe", "Smoe");
        this.identityService.createMembership("joesmoe", this.deptHR, "HRManager");
        this.identityService.createUser("janedoe", "Jane", "Doe");
        this.identityService.createMembership("janedoe", this.deptFinance, "FinanceManager");
        this.deploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/examples/concurrency/foreach/process.jpdl.xml").deploy();
    }

    protected void tearDown() throws Exception {
        this.repositoryService.deleteDeploymentCascade(this.deploymentId);
        this.identityService.deleteGroup(this.deptSales);
        this.identityService.deleteGroup(this.deptHR);
        this.identityService.deleteGroup(this.deptFinance);
        this.identityService.deleteUser("johndoe");
        this.identityService.deleteUser("joesmoe");
        this.identityService.deleteUser("janedoe");
        super.tearDown();
    }

    public void testForEachCompleteAll() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("departments", new String[]{"sales-dept", "hr-dept", "finance-dept"});
        variables.put("quorum", 3);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("ForEach", variables);
        ForEachTest.assertEquals((int)3, (int)processInstance.getExecutions().size());
        List taskListSales = this.taskService.findGroupTasks("johndoe");
        ForEachTest.assertEquals((String)"Expected a single task in johndoe's task list", (int)1, (int)taskListSales.size());
        List taskListHR = this.taskService.findGroupTasks("joesmoe");
        ForEachTest.assertEquals((String)"Expected a single task in joesmoe's task list", (int)1, (int)taskListHR.size());
        List taskListFinance = this.taskService.findGroupTasks("janedoe");
        ForEachTest.assertEquals((String)"Expected a single task in janedoe's task list", (int)1, (int)taskListFinance.size());
        this.taskService.takeTask(((Task)taskListSales.get(0)).getId(), "johndoe");
        taskListSales = this.taskService.findPersonalTasks("johndoe");
        ForEachTest.assertEquals((String)"Expected a single task being created", (int)1, (int)taskListSales.size());
        this.taskService.completeTask(((Task)taskListSales.get(0)).getId());
        this.taskService.takeTask(((Task)taskListHR.get(0)).getId(), "joesmoe");
        taskListHR = this.taskService.findPersonalTasks("joesmoe");
        ForEachTest.assertEquals((String)"Expected a single task being created", (int)1, (int)taskListHR.size());
        this.taskService.completeTask(((Task)taskListHR.get(0)).getId());
        this.taskService.takeTask(((Task)taskListFinance.get(0)).getId(), "janedoe");
        taskListFinance = this.taskService.findPersonalTasks("janedoe");
        ForEachTest.assertEquals((String)"Expected a single task being created", (int)1, (int)taskListFinance.size());
        this.taskService.completeTask(((Task)taskListFinance.get(0)).getId());
        Date endTime = this.historyService.createHistoryProcessInstanceQuery().processInstanceId(processInstance.getId()).uniqueResult().getEndTime();
        ForEachTest.assertNotNull((Object)endTime);
    }

    public void testForEachCompleteAfterTwoJoined() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("departments", new String[]{"sales-dept", "hr-dept", "finance-dept"});
        variables.put("quorum", 2);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("ForEach", variables);
        ForEachTest.assertEquals((int)3, (int)processInstance.getExecutions().size());
        List taskListSales = this.taskService.findGroupTasks("johndoe");
        ForEachTest.assertEquals((String)"Expected a single task in johndoe's task list", (int)1, (int)taskListSales.size());
        List taskListHR = this.taskService.findGroupTasks("joesmoe");
        ForEachTest.assertEquals((String)"Expected a single task in joesmoe's task list", (int)1, (int)taskListHR.size());
        List taskListFinance = this.taskService.findGroupTasks("janedoe");
        ForEachTest.assertEquals((String)"Expected a single task in janedoe's task list", (int)1, (int)taskListFinance.size());
        this.taskService.takeTask(((Task)taskListSales.get(0)).getId(), "johndoe");
        taskListSales = this.taskService.findPersonalTasks("johndoe");
        ForEachTest.assertEquals((String)"Expected a single task being created", (int)1, (int)taskListSales.size());
        this.taskService.completeTask(((Task)taskListSales.get(0)).getId());
        this.taskService.takeTask(((Task)taskListHR.get(0)).getId(), "joesmoe");
        taskListSales = this.taskService.findPersonalTasks("joesmoe");
        ForEachTest.assertEquals((String)"Expected a single task being created", (int)1, (int)taskListSales.size());
        this.taskService.completeTask(((Task)taskListSales.get(0)).getId());
        Date endTime = this.historyService.createHistoryProcessInstanceQuery().processInstanceId(processInstance.getId()).uniqueResult().getEndTime();
        ForEachTest.assertNotNull((Object)endTime);
    }
}

