/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.bpmn.gateway.inclusive;

import java.util.HashMap;
import java.util.List;
import org.jbpm.api.NewDeployment;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.TaskQuery;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;

public class InclusiveGatewayTest
extends JbpmTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        NewDeployment deployment = this.repositoryService.createDeployment();
        deployment.addResourceFromClasspath("org/jbpm/examples/bpmn/gateway/inclusive/inclusive_gateway.bpmn.xml");
        this.registerDeployment(deployment.deploy());
    }

    public void testLargeDeposit() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("cash", 15000);
        vars.put("bank", "local");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("inclusiveGateway", vars);
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        InclusiveGatewayTest.assertEquals((long)1L, (long)taskQuery.count());
        Task largeDepositTask = taskQuery.uniqueResult();
        InclusiveGatewayTest.assertEquals((String)"Large deposit", (String)largeDepositTask.getName());
        this.taskService.completeTask(largeDepositTask.getId());
        this.assertProcessInstanceEnded(processInstance);
    }

    public void testLargeForeignDeposit() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("cash", 20000);
        vars.put("bank", "foreign");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("inclusiveGateway", vars);
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).orderAsc("name");
        List tasks = taskQuery.list();
        InclusiveGatewayTest.assertEquals((int)2, (int)tasks.size());
        InclusiveGatewayTest.assertEquals((String)"Foreign deposit", (String)((Task)tasks.get(0)).getName());
        InclusiveGatewayTest.assertEquals((String)"Large deposit", (String)((Task)tasks.get(1)).getName());
        for (Task task : tasks) {
            this.taskService.completeTask(task.getId());
        }
        this.assertProcessInstanceEnded(processInstance);
    }

    public void testStandardDeposit() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("cash", 7000);
        vars.put("bank", "local");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("inclusiveGateway", vars);
        TaskQuery taskQuery = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        InclusiveGatewayTest.assertEquals((long)1L, (long)taskQuery.count());
        Task standardDeposit = taskQuery.uniqueResult();
        InclusiveGatewayTest.assertEquals((String)"Standard deposit", (String)standardDeposit.getName());
        this.taskService.completeTask(standardDeposit.getId());
        this.assertProcessInstanceEnded(processInstance);
    }
}

