/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.bpmn.gateway.exclusive;

import java.util.HashMap;
import org.jbpm.api.NewDeployment;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.history.HistoryProcessInstance;
import org.jbpm.test.JbpmTestCase;

public class ExclusiveGatewayWithDefaultSequenceFlowTest
extends JbpmTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        NewDeployment deployment = this.repositoryService.createDeployment();
        deployment.addResourceFromClasspath("org/jbpm/examples/bpmn/gateway/exclusive/exclusive_gateway_default_seq_flow.bpmn.xml");
        this.registerDeployment(deployment.deploy());
    }

    public void testWithLargeDeposit() {
        this.startAndVerifyProcess(9999, "localBank", "largeDeposit");
    }

    public void testWithForeignBankt() {
        this.startAndVerifyProcess(9999, "foreign", "foreignBank");
    }

    public void testDefaultSequenceFlow() {
        this.startAndVerifyProcess(1, "local", "standard");
    }

    private void startAndVerifyProcess(int amount, String bankType, String endId) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("amount", amount);
        vars.put("bankType", bankType);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("exclusiveGatewayDefaultSeqFlow", vars);
        this.assertProcessInstanceEnded(processInstance);
        HistoryProcessInstance historyProcessInstance = this.historyService.createHistoryProcessInstanceQuery().processInstanceId(processInstance.getId()).uniqueResult();
        ExclusiveGatewayWithDefaultSequenceFlowTest.assertEquals((String)endId, (String)historyProcessInstance.getEndActivityName());
    }
}

