/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.bpmn.event.timerstart;

import java.util.Date;
import org.jbpm.api.NewDeployment;
import org.jbpm.api.ProcessInstanceQuery;
import org.jbpm.api.job.Job;
import org.jbpm.pvm.internal.util.Clock;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.util.DateUtils;

public class TimerStartTest
extends JbpmTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        Clock.setExplicitTime((Date)DateUtils.getDateAtMidnight((int)10, (int)9, (int)2099));
        NewDeployment deployment = this.repositoryService.createDeployment();
        deployment.addResourceFromClasspath("org/jbpm/examples/bpmn/event/timerstart/timer_start_event.bpmn.xml");
        this.registerDeployment(deployment.deploy());
    }

    protected void tearDown() throws Exception {
        Clock.setExplicitTime(null);
        super.tearDown();
    }

    public void testTimerStartEventWithDurationAsTimeCycle() {
        Job startProcessTimer = this.managementService.createJobQuery().uniqueResult();
        TimerStartTest.assertNotNull((Object)startProcessTimer);
        TimerStartTest.assertEquals((long)DateUtils.getDate((int)10, (int)9, (int)2099, (int)10, (int)0, (int)0).getTime(), (long)startProcessTimer.getDuedate().getTime());
        ProcessInstanceQuery procInstQuery = this.executionService.createProcessInstanceQuery();
        TimerStartTest.assertEquals((long)0L, (long)procInstQuery.count());
        Clock.setExplicitTime((Date)DateUtils.getDate((int)10, (int)9, (int)2099, (int)10, (int)0, (int)0));
        this.managementService.executeJob(startProcessTimer.getId());
        TimerStartTest.assertEquals((long)1L, (long)procInstQuery.count());
        startProcessTimer = this.managementService.createJobQuery().uniqueResult();
        TimerStartTest.assertEquals((long)DateUtils.getDate((int)10, (int)9, (int)2099, (int)20, (int)0, (int)0).getTime(), (long)startProcessTimer.getDuedate().getTime());
        this.managementService.deleteJob(Long.valueOf(startProcessTimer.getId()).longValue());
    }
}

