/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.async.activity;

import org.jbpm.api.ProcessInstance;
import org.jbpm.api.job.Job;
import org.jbpm.test.JbpmTestCase;

public class AsyncActivityTest
extends JbpmTestCase {
    String deploymentId;

    protected void setUp() throws Exception {
        super.setUp();
        this.deploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/examples/async/activity/process.jpdl.xml").deploy();
    }

    protected void tearDown() throws Exception {
        this.repositoryService.deleteDeploymentCascade(this.deploymentId);
        super.tearDown();
    }

    public void testAsyncActivity() {
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("AsyncActivity");
        String processInstanceId = processInstance.getId();
        AsyncActivityTest.assertEquals((String)"async", (String)processInstance.getState());
        Job job = this.managementService.createJobQuery().processInstanceId(processInstanceId).uniqueResult();
        this.managementService.executeJob(job.getId());
        processInstance = this.executionService.findProcessInstanceById(processInstanceId);
        AsyncActivityTest.assertEquals((String)"async", (String)processInstance.getState());
        job = this.managementService.createJobQuery().processInstanceId(processInstanceId).uniqueResult();
        this.managementService.executeJob(job.getId());
        AsyncActivityTest.assertNull((Object)this.executionService.findProcessInstanceById(processInstanceId));
    }
}

