/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.task;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jbpm.api.task.Participation;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskParticipationsTest
extends JbpmTestCase {
    public void testTaskParticipants() {
        Task task = this.taskService.newTask();
        task.setName("do laundry");
        String taskId = this.taskService.saveTask(task);
        this.taskService.addTaskParticipatingUser(taskId, "johndoe", "candidate");
        this.taskService.addTaskParticipatingUser(taskId, "joesmoe", "candidate");
        this.taskService.addTaskParticipatingUser(taskId, "joesmoe", "owner");
        this.taskService.addTaskParticipatingGroup(taskId, "losers", "candidate");
        this.taskService.addTaskParticipatingGroup(taskId, "dummies", "candidate");
        List taskParticipations = this.taskService.getTaskParticipations(taskId);
        Set<String> candidateUserIds = this.extractParticipatingUserIds(taskParticipations, "candidate");
        Set<String> ownerUserIds = this.extractParticipatingUserIds(taskParticipations, "owner");
        Set<String> candidateGroupIds = this.extractParticipatingGroupIds(taskParticipations, "candidate");
        HashSet<String> expectedIds = new HashSet<String>();
        expectedIds.add("johndoe");
        expectedIds.add("joesmoe");
        TaskParticipationsTest.assertEquals(expectedIds, candidateUserIds);
        expectedIds = new HashSet();
        expectedIds.add("joesmoe");
        TaskParticipationsTest.assertEquals(expectedIds, ownerUserIds);
        expectedIds = new HashSet();
        expectedIds.add("losers");
        expectedIds.add("dummies");
        TaskParticipationsTest.assertEquals(expectedIds, candidateGroupIds);
        this.taskService.removeTaskParticipatingUser(taskId, "joesmoe", "owner");
        this.taskService.removeTaskParticipatingGroup(taskId, "losers", "candidate");
        taskParticipations = this.taskService.getTaskParticipations(taskId);
        candidateUserIds = this.extractParticipatingUserIds(taskParticipations, "candidate");
        ownerUserIds = this.extractParticipatingUserIds(taskParticipations, "owner");
        candidateGroupIds = this.extractParticipatingGroupIds(taskParticipations, "candidate");
        expectedIds = new HashSet();
        expectedIds.add("johndoe");
        expectedIds.add("joesmoe");
        TaskParticipationsTest.assertEquals(expectedIds, candidateUserIds);
        expectedIds = new HashSet();
        TaskParticipationsTest.assertEquals(expectedIds, ownerUserIds);
        expectedIds = new HashSet();
        expectedIds.add("dummies");
        TaskParticipationsTest.assertEquals(expectedIds, candidateGroupIds);
        this.taskService.deleteTaskCascade(taskId);
    }

    public Set<String> extractParticipatingUserIds(List<Participation> taskParticipations, String participationType) {
        HashSet<String> userIds = new HashSet<String>();
        for (Participation participation : taskParticipations) {
            if (!participationType.equals(participation.getType()) || participation.getUserId() == null) continue;
            userIds.add(participation.getUserId());
        }
        return userIds;
    }

    public Set<String> extractParticipatingGroupIds(List<Participation> taskParticipations, String participationType) {
        HashSet<String> groupIds = new HashSet<String>();
        for (Participation participation : taskParticipations) {
            if (!participationType.equals(participation.getType()) || participation.getGroupId() == null) continue;
            groupIds.add(participation.getGroupId());
        }
        return groupIds;
    }
}

