/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.query;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jbpm.api.Deployment;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.assertion.QueryAssertions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentQueryTest
extends JbpmTestCase {
    public void testSuspendDeployment() {
        List<String> deploymentIds = this.deployTestProcesses();
        this.repositoryService.suspendDeployment(deploymentIds.get(2));
        List deployments = this.repositoryService.createDeploymentQuery().list();
        HashSet<String> expectedDeploymentNames = new HashSet<String>();
        expectedDeploymentNames.add("Claim");
        expectedDeploymentNames.add("Hire");
        expectedDeploymentNames.add("Fire");
        DeploymentQueryTest.assertEquals(expectedDeploymentNames, this.getDeploymentNames(deployments));
        deployments = this.repositoryService.createDeploymentQuery().suspended().list();
        expectedDeploymentNames = new HashSet();
        expectedDeploymentNames.add("Hire");
        DeploymentQueryTest.assertEquals(expectedDeploymentNames, this.getDeploymentNames(deployments));
        deployments = this.repositoryService.createDeploymentQuery().notSuspended().list();
        expectedDeploymentNames = new HashSet();
        expectedDeploymentNames.add("Claim");
        expectedDeploymentNames.add("Fire");
        DeploymentQueryTest.assertEquals(expectedDeploymentNames, this.getDeploymentNames(deployments));
        this.deleteCascade(deploymentIds);
    }

    private void deleteCascade(List<String> deploymentIds) {
        for (String deploymentId : deploymentIds) {
            this.repositoryService.deleteDeploymentCascade(deploymentId);
        }
    }

    public void testOrderByTimeStamp() {
        this.testOrderByNaturalOrdening("timestamp", 3);
    }

    public void testCount() {
        List<String> deploymentIds = this.deployTestProcesses();
        DeploymentQueryTest.assertEquals((long)3L, (long)this.repositoryService.createDeploymentQuery().count());
        for (String deploymentId : deploymentIds) {
            DeploymentQueryTest.assertEquals((long)1L, (long)this.repositoryService.createDeploymentQuery().deploymentId(deploymentId).count());
        }
        Deployment deployment = this.repositoryService.createDeploymentQuery().deploymentId(deploymentIds.get(0)).uniqueResult();
        this.repositoryService.suspendDeployment(deployment.getId());
        DeploymentQueryTest.assertEquals((long)1L, (long)this.repositoryService.createDeploymentQuery().suspended().count());
        DeploymentQueryTest.assertEquals((long)2L, (long)this.repositoryService.createDeploymentQuery().notSuspended().count());
        this.deleteCascade(deploymentIds);
    }

    private Set<String> getDeploymentNames(List<Deployment> deployments) {
        HashSet<String> deploymentNames = new HashSet<String>();
        for (Deployment deployment : deployments) {
            deploymentNames.add(deployment.getName());
        }
        return deploymentNames;
    }

    private List<String> deployTestProcesses() {
        ArrayList<String> processIds = new ArrayList<String>();
        String deploymentClaimId = this.repositoryService.createDeployment().setName("Claim").addResourceFromString("process.jpdl.xml", "<process name='claim'>  <start>    <transition to='c' />  </start>  <state name='c' /></process>").deploy();
        String deploymentHireId = this.repositoryService.createDeployment().setName("Hire").addResourceFromString("process.jpdl.xml", "<process name='hire'>  <start>    <transition to='h' />  </start>  <state name='h' /></process>").deploy();
        String deploymentFireId = this.repositoryService.createDeployment().setName("Fire").addResourceFromString("process.jpdl.xml", "<process name='fire'>  <start>    <transition to='f' />  </start>  <state name='f' /></process>").deploy();
        processIds.add(deploymentClaimId);
        processIds.add(deploymentFireId);
        processIds.add(deploymentHireId);
        return processIds;
    }

    private void testOrderBy(String property, List expectedValues) {
        this.testOrderBy(property, expectedValues, null, false);
    }

    private void testOrderByNaturalOrdening(String property, int expectedNrOfResults) {
        this.testOrderBy(property, null, expectedNrOfResults, true);
    }

    private void testOrderBy(String property, List expectedValues, Integer expectedNrOfResults, boolean naturalOrderCheck) {
        List<String> deploymentIds = this.deployTestProcesses();
        List deploymentsAsc = this.repositoryService.createDeploymentQuery().orderAsc(property).list();
        List deploymentsDesc = this.repositoryService.createDeploymentQuery().orderDesc(property).list();
        if (naturalOrderCheck) {
            QueryAssertions.assertOrderIsNatural(Deployment.class, (String)property, (List)deploymentsAsc, (List)deploymentsDesc, (int)3);
        } else {
            QueryAssertions.assertOrderOnProperty(Deployment.class, (String)property, (List)deploymentsAsc, (List)deploymentsDesc, (List)expectedValues);
        }
        this.deleteCascade(deploymentIds);
    }
}

