/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.process;

import org.jbpm.api.JbpmException;
import org.jbpm.api.ProcessInstanceQuery;
import org.jbpm.api.history.HistoryProcessInstanceQuery;
import org.jbpm.test.JbpmTestCase;

public class DeleteProcessInstanceTest
extends JbpmTestCase {
    private static final String SIMPLE_PROCESS = "<process name='simpleProcess'>  <start >    <transition to='wait' />  </start>  <state name='wait' >    <transition to='theEnd' />  </state>  <end name='theEnd' /></process>";

    protected void setUp() throws Exception {
        super.setUp();
        this.deployJpdlXmlString(SIMPLE_PROCESS);
    }

    public void testDeleteExistingProcess() {
        String id = this.executionService.startProcessInstanceByKey("simpleProcess").getId();
        ProcessInstanceQuery query = this.executionService.createProcessInstanceQuery().processInstanceId(id);
        DeleteProcessInstanceTest.assertNotNull((Object)query.uniqueResult());
        this.executionService.deleteProcessInstance(id);
        DeleteProcessInstanceTest.assertNull((Object)query.uniqueResult());
        HistoryProcessInstanceQuery historyQuery = this.historyService.createHistoryProcessInstanceQuery().processInstanceId(id);
        DeleteProcessInstanceTest.assertNotNull((Object)historyQuery.uniqueResult());
    }

    public void testDeleteCascadeExistingProcess() {
        String id = this.executionService.startProcessInstanceByKey("simpleProcess").getId();
        ProcessInstanceQuery query = this.executionService.createProcessInstanceQuery().processInstanceId(id);
        DeleteProcessInstanceTest.assertNotNull((Object)query.uniqueResult());
        this.executionService.deleteProcessInstanceCascade(id);
        DeleteProcessInstanceTest.assertNull((Object)query.uniqueResult());
        HistoryProcessInstanceQuery historyQuery = this.historyService.createHistoryProcessInstanceQuery().processInstanceId(id);
        DeleteProcessInstanceTest.assertNull((Object)historyQuery.uniqueResult());
    }

    public void testDeleteUnexistingProcessInstance() {
        try {
            this.executionService.deleteProcessInstance("-1");
            DeleteProcessInstanceTest.fail((String)"Expected exception");
        }
        catch (JbpmException jbpmException) {
            // empty catch block
        }
    }

    public void testDeleteCascadeUnexistingProcessInstance() {
        try {
            this.executionService.deleteProcessInstanceCascade("-1");
            DeleteProcessInstanceTest.fail((String)"Expected exception");
        }
        catch (JbpmException jbpmException) {
            // empty catch block
        }
    }
}

