/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.execution;

import java.util.Map;
import junit.framework.Assert;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.api.activity.ExternalActivityBehaviour;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.test.JbpmTestCase;

public class SystemVariablesTest
extends JbpmTestCase {
    public void testSystemVariables() {
        this.deployJpdlXmlString("<process name='SystemVariables'>  <start>    <transition to='c' />  </start>  <custom name='c' class='" + Systematic.class.getName() + "'>" + "    <transition to='end' />" + "  </custom>" + "  <end name='end' />" + "</process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("SystemVariables");
        String pid = processInstance.getId();
        SystemVariablesTest.assertTrue((boolean)this.executionService.getVariableNames(pid).isEmpty());
        this.executionService.signalExecutionById(pid);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Systematic
    implements ExternalActivityBehaviour {
        private static final long serialVersionUID = 1L;

        public void execute(ActivityExecution execution) throws Exception {
            ExecutionImpl executionImpl = (ExecutionImpl)execution;
            executionImpl.setSystemVariable("secret", (Object)"jbpm rocks");
            execution.waitForSignal();
        }

        public void signal(ActivityExecution execution, String signalName, Map<String, ?> parameters) throws Exception {
            ExecutionImpl executionImpl = (ExecutionImpl)execution;
            Assert.assertEquals((Object)"jbpm rocks", (Object)executionImpl.getSystemVariable("secret"));
            Assert.assertTrue((boolean)execution.getVariableKeys().isEmpty());
        }
    }
}

