/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.deploy;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.jbpm.api.ProcessDefinition;
import org.jbpm.pvm.internal.util.IoUtil;
import org.jbpm.test.JbpmTestCase;

public class ImageTest
extends JbpmTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImage() throws IOException {
        String deploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/test/deploy/ImageTest.jpdl.xml").addResourceFromClasspath("org/jbpm/test/deploy/ImageTest.png").deploy();
        ProcessDefinition processDefinition = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("ImageTest").uniqueResult();
        String imageResourceName = processDefinition.getImageResourceName();
        ImageTest.assertEquals((String)"org/jbpm/test/deploy/ImageTest.png", (String)imageResourceName);
        InputStream imageStream = this.repositoryService.getResourceAsStream(deploymentId, imageResourceName);
        try {
            byte[] imageBytes = IoUtil.readBytes((InputStream)imageStream);
            InputStream expectedImageStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("org/jbpm/test/deploy/ImageTest.png");
            try {
                byte[] expectedImageBytes = IoUtil.readBytes((InputStream)expectedImageStream);
                ImageTest.assertTrue((boolean)Arrays.equals(expectedImageBytes, imageBytes));
            }
            finally {
                IoUtil.close((Closeable)expectedImageStream);
            }
        }
        finally {
            IoUtil.close((Closeable)imageStream);
        }
        this.repositoryService.deleteDeploymentCascade(deploymentId);
    }
}

