/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activity.task;

import java.util.HashSet;
import java.util.Set;
import org.jbpm.api.JbpmException;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;

public class TaskOutcomesTest
extends JbpmTestCase {
    private static final String UNNAMED_TRANSITION_PROCESS_NAME = "UnnamedTransition";
    private static final String UNNAMED_TRANSITION_PROCESS = "<process name='UnnamedTransition'>  <start>    <transition to='review' />  </start>  <task name='review'         assignee='johndoe'>    <transition to='wait' />  </task>  <state name='wait'/></process>";
    private static final String NAMED_TRANSITION_PROCESS_NAME = "NamedTransition";
    private static final String NAMED_TRANSITION_PROCESS = "<process name='NamedTransition'>  <start>    <transition to='review' />  </start>  <task name='review'         assignee='johndoe'>    <transition name='theOneAndOnly' to='wait' />  </task>  <state name='wait'/></process>";
    private static final String NO_TRANSITION_PROCESS_NAME = "NoTransition";
    private static final String NO_TRANSITION_PROCESS = "<process name='NoTransition'>  <start>    <transition to='review' />  </start>  <task name='review'         assignee='johndoe'>  </task>  <state name='wait'/></process>";
    private static final String MULTIPLE_NAMED_TRANSITIONS_PROCESS_NAME = "MultipleTransitions";
    private static final String MULTIPLE_NAMED_TRANSITIONS_PROCESS = "<process name='MultipleTransitions'>  <start>    <transition to='review' />  </start>  <task name='review'         assignee='johndoe'>    <transition name='left' to='wait1' />    <transition name='middle' to='wait2' />    <transition name='right' to='wait3' />  </task>  <state name='wait1'/>  <state name='wait2'/>  <state name='wait3'/></process>";
    private static final String MULTIPLE_NOT_ALL_NAMED_TRANSITIONS_PROCESS_NAME = "MultipleTransitionsWithUnnamed";
    private static final String MULTIPLE_NOT_ALL_NAMED_TRANSITIONS_PROCESS = "<process name='MultipleTransitionsWithUnnamed'>  <start>    <transition to='review' />  </start>  <task name='review'         assignee='johndoe'>    <transition name='left' to='wait1' />    <transition to='wait2' />    <transition name='right' to='wait3' />  </task>  <state name='wait1'/>  <state name='wait2'/>  <state name='wait3'/></process>";

    public void testGetOutcomesNoTransition() {
        this.deployJpdlXmlString(NO_TRANSITION_PROCESS);
        this.executionService.startProcessInstanceByKey(NO_TRANSITION_PROCESS_NAME);
        Task task = this.taskService.createTaskQuery().assignee("johndoe").uniqueResult();
        Set outcomes = this.taskService.getOutcomes(task.getId());
        HashSet expectedOutcomes = new HashSet();
        TaskOutcomesTest.assertEquals(expectedOutcomes, (Object)outcomes);
    }

    public void testGetOutcomesSingleUnnamedTransition() {
        this.deployJpdlXmlString(UNNAMED_TRANSITION_PROCESS);
        this.executionService.startProcessInstanceByKey(UNNAMED_TRANSITION_PROCESS_NAME);
        Task task = this.taskService.createTaskQuery().assignee("johndoe").uniqueResult();
        Set outcomes = this.taskService.getOutcomes(task.getId());
        HashSet<Object> expectedOutcomes = new HashSet<Object>();
        expectedOutcomes.add(null);
        TaskOutcomesTest.assertEquals(expectedOutcomes, (Object)outcomes);
    }

    public void testGetOutcomesSingleNamedTransition() {
        this.deployJpdlXmlString(NAMED_TRANSITION_PROCESS);
        this.executionService.startProcessInstanceByKey(NAMED_TRANSITION_PROCESS_NAME);
        Task task = this.taskService.createTaskQuery().assignee("johndoe").uniqueResult();
        Set outcomes = this.taskService.getOutcomes(task.getId());
        HashSet<String> expectedOutcomes = new HashSet<String>();
        expectedOutcomes.add("theOneAndOnly");
        TaskOutcomesTest.assertEquals(expectedOutcomes, (Object)outcomes);
    }

    public void testGetOutcomesMultipleTransitionsAllNamed() {
        this.deployJpdlXmlString(MULTIPLE_NAMED_TRANSITIONS_PROCESS);
        this.executionService.startProcessInstanceByKey(MULTIPLE_NAMED_TRANSITIONS_PROCESS_NAME);
        Task task = this.taskService.createTaskQuery().assignee("johndoe").uniqueResult();
        Set outcomes = this.taskService.getOutcomes(task.getId());
        HashSet<String> expectedOutcomes = new HashSet<String>();
        expectedOutcomes.add("left");
        expectedOutcomes.add("right");
        expectedOutcomes.add("middle");
        TaskOutcomesTest.assertEquals(expectedOutcomes, (Object)outcomes);
    }

    public void testGetOutcomesMultipleTransitionsNotAllNamed() {
        this.deployJpdlXmlString(MULTIPLE_NOT_ALL_NAMED_TRANSITIONS_PROCESS);
        this.executionService.startProcessInstanceByKey(MULTIPLE_NOT_ALL_NAMED_TRANSITIONS_PROCESS_NAME);
        Task task = this.taskService.createTaskQuery().assignee("johndoe").uniqueResult();
        Set outcomes = this.taskService.getOutcomes(task.getId());
        HashSet<String> expectedOutcomes = new HashSet<String>();
        expectedOutcomes.add("left");
        expectedOutcomes.add(null);
        expectedOutcomes.add("right");
        TaskOutcomesTest.assertEquals(expectedOutcomes, (Object)outcomes);
    }

    public void testCompleteTaskWithOneUnnamedTransitionById() {
        this.deployJpdlXmlString(UNNAMED_TRANSITION_PROCESS);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey(UNNAMED_TRANSITION_PROCESS_NAME);
        Task task = this.taskService.createTaskQuery().assignee("johndoe").uniqueResult();
        this.taskService.completeTask(task.getId());
        processInstance = this.executionService.findProcessInstanceById(processInstance.getId());
        TaskOutcomesTest.assertNotNull((Object)processInstance.findActiveExecutionIn("wait"));
    }

    public void testCompleteTaskWithOneUnnamedTransitionByIdAndNullTransition() {
        this.deployJpdlXmlString(UNNAMED_TRANSITION_PROCESS);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey(UNNAMED_TRANSITION_PROCESS_NAME);
        Task task = this.taskService.createTaskQuery().assignee("johndoe").uniqueResult();
        this.taskService.completeTask(task.getId(), (String)null);
        processInstance = this.executionService.findProcessInstanceById(processInstance.getId());
        TaskOutcomesTest.assertNotNull((Object)processInstance.findActiveExecutionIn("wait"));
    }

    public void testCompleteTaskWithOneUnnamedTransitionByIdAndWrongTransition() {
        this.deployJpdlXmlString(UNNAMED_TRANSITION_PROCESS);
        this.executionService.startProcessInstanceByKey(UNNAMED_TRANSITION_PROCESS_NAME);
        Task task = this.taskService.createTaskQuery().assignee("johndoe").uniqueResult();
        try {
            this.taskService.completeTask(task.getId(), "anyValue");
            TaskOutcomesTest.fail();
        }
        catch (JbpmException e) {
            e.printStackTrace();
        }
        TaskOutcomesTest.assertNotNull((String)"After completion with an invalid outcome, the task should remain unchanged", (Object)this.taskService.createTaskQuery().assignee("johndoe").uniqueResult());
    }

    public void testCompleteTaskWithSingleNamedTransitionById() {
        this.deployJpdlXmlString(NAMED_TRANSITION_PROCESS);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey(NAMED_TRANSITION_PROCESS_NAME);
        Task task = this.taskService.createTaskQuery().assignee("johndoe").uniqueResult();
        this.taskService.completeTask(task.getId());
        processInstance = this.executionService.findProcessInstanceById(processInstance.getId());
        TaskOutcomesTest.assertNotNull((Object)processInstance.findActiveExecutionIn("wait"));
    }

    public void testCompleteTaskWithSingleNamedTransitionByIdAndNullTransition() {
        this.deployJpdlXmlString(NAMED_TRANSITION_PROCESS);
        this.executionService.startProcessInstanceByKey(NAMED_TRANSITION_PROCESS_NAME);
        Task task = this.taskService.createTaskQuery().assignee("johndoe").uniqueResult();
        try {
            this.taskService.completeTask(task.getId(), (String)null);
            TaskOutcomesTest.fail();
        }
        catch (JbpmException jbpmException) {
            // empty catch block
        }
        TaskOutcomesTest.assertNotNull((Object)this.taskService.createTaskQuery().assignee("johndoe").uniqueResult());
    }

    public void testCompleteTaskWithSingleNamedTransitionByIdAndWrongTransition() {
        this.deployJpdlXmlString(NAMED_TRANSITION_PROCESS);
        this.executionService.startProcessInstanceByKey(NAMED_TRANSITION_PROCESS_NAME);
        Task task = this.taskService.createTaskQuery().assignee("johndoe").uniqueResult();
        try {
            this.taskService.completeTask(task.getId(), "anyValue");
            TaskOutcomesTest.fail();
        }
        catch (JbpmException jbpmException) {
            // empty catch block
        }
        TaskOutcomesTest.assertNotNull((String)"After completion with an invalid outcome, the task should remain unchanged", (Object)this.taskService.createTaskQuery().assignee("johndoe").uniqueResult());
    }

    public void testCompleteTaskWithSingleNamedTransitionByIdAndTransition() {
        this.deployJpdlXmlString(NAMED_TRANSITION_PROCESS);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey(NAMED_TRANSITION_PROCESS_NAME);
        Task task = this.taskService.createTaskQuery().assignee("johndoe").uniqueResult();
        this.taskService.completeTask(task.getId(), "theOneAndOnly");
        this.assertActivityActive(processInstance.getId(), "wait");
    }

    public void testCompleteTaskWithMultipleTransitionsNotAllNamedById() {
        this.deployJpdlXmlString(MULTIPLE_NOT_ALL_NAMED_TRANSITIONS_PROCESS);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey(MULTIPLE_NOT_ALL_NAMED_TRANSITIONS_PROCESS_NAME);
        Task task = this.taskService.createTaskQuery().assignee("johndoe").uniqueResult();
        this.taskService.completeTask(task.getId());
        this.assertActivityActive(processInstance.getId(), "wait2");
    }

    public void testCompleteTaskWithMultipleTransitionsNotAllNamedByIdAndNullTransition() {
        this.deployJpdlXmlString(MULTIPLE_NOT_ALL_NAMED_TRANSITIONS_PROCESS);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey(MULTIPLE_NOT_ALL_NAMED_TRANSITIONS_PROCESS_NAME);
        Task task = this.taskService.createTaskQuery().assignee("johndoe").uniqueResult();
        this.taskService.completeTask(task.getId(), (String)null);
        this.assertActivityActive(processInstance.getId(), "wait2");
    }

    public void testCompleteTaskWithMultipleTransitionsNotAllNamedByIdAndWrongTransition() {
        this.deployJpdlXmlString(MULTIPLE_NOT_ALL_NAMED_TRANSITIONS_PROCESS);
        this.executionService.startProcessInstanceByKey(MULTIPLE_NOT_ALL_NAMED_TRANSITIONS_PROCESS_NAME);
        Task task = this.taskService.createTaskQuery().assignee("johndoe").uniqueResult();
        try {
            this.taskService.completeTask(task.getId(), "anyValue");
            TaskOutcomesTest.fail();
        }
        catch (JbpmException jbpmException) {
            // empty catch block
        }
        TaskOutcomesTest.assertNotNull((String)"After completion with an invalid outcome, the task should remain unchanged", (Object)this.taskService.createTaskQuery().assignee("johndoe").uniqueResult());
    }

    public void testCompleteTaskWithMultipleTransitionsNotAllNamedByIdAndTransition() {
        this.deployJpdlXmlString(MULTIPLE_NOT_ALL_NAMED_TRANSITIONS_PROCESS);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey(MULTIPLE_NOT_ALL_NAMED_TRANSITIONS_PROCESS_NAME);
        Task task = this.taskService.createTaskQuery().assignee("johndoe").uniqueResult();
        this.taskService.completeTask(task.getId(), "right");
        this.assertActivityActive(processInstance.getId(), "wait3");
    }

    public void testCompleteTaskWithMultipleTransitionsAllNamedById() {
        this.deployJpdlXmlString(MULTIPLE_NAMED_TRANSITIONS_PROCESS);
        this.executionService.startProcessInstanceByKey(MULTIPLE_NAMED_TRANSITIONS_PROCESS_NAME);
        Task task = this.taskService.createTaskQuery().assignee("johndoe").uniqueResult();
        try {
            this.taskService.completeTask(task.getId());
            TaskOutcomesTest.fail();
        }
        catch (JbpmException jbpmException) {
            // empty catch block
        }
    }

    public void testCompleteTaskWithMultipleTransitionsAllNamedByIdAndNullTransition() {
        this.deployJpdlXmlString(MULTIPLE_NAMED_TRANSITIONS_PROCESS);
        this.executionService.startProcessInstanceByKey(MULTIPLE_NAMED_TRANSITIONS_PROCESS_NAME);
        Task task = this.taskService.createTaskQuery().assignee("johndoe").uniqueResult();
        try {
            this.taskService.completeTask(task.getId());
        }
        catch (JbpmException jbpmException) {
            // empty catch block
        }
        TaskOutcomesTest.assertNotNull((Object)this.taskService.createTaskQuery().assignee("johndoe").uniqueResult());
    }

    public void testCompleteTaskWithMultipleTransitionsAllNamedByIdAndWrongTransition() {
        this.deployJpdlXmlString(MULTIPLE_NAMED_TRANSITIONS_PROCESS);
        this.executionService.startProcessInstanceByKey(MULTIPLE_NAMED_TRANSITIONS_PROCESS_NAME);
        Task task = this.taskService.createTaskQuery().assignee("johndoe").uniqueResult();
        try {
            this.taskService.completeTask(task.getId());
            TaskOutcomesTest.fail();
        }
        catch (JbpmException jbpmException) {
            // empty catch block
        }
        TaskOutcomesTest.assertNotNull((String)"After completion with an invalid outcome, the task should remain unchanged", (Object)this.taskService.createTaskQuery().assignee("johndoe").uniqueResult());
    }

    public void testCompleteTaskWithMultipleTransitionsAllNamedByIdAndTransition() {
        this.deployJpdlXmlString(MULTIPLE_NAMED_TRANSITIONS_PROCESS);
        ProcessInstance pi = this.executionService.startProcessInstanceByKey(MULTIPLE_NAMED_TRANSITIONS_PROCESS_NAME);
        Task task = this.taskService.createTaskQuery().assignee("johndoe").uniqueResult();
        this.taskService.completeTask(task.getId(), "left");
        this.assertActivityActive(pi.getId(), "wait1");
    }
}

