/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activity.mail;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMessage;
import junit.framework.Test;
import org.jbpm.api.ProcessInstance;
import org.jbpm.pvm.internal.util.IoUtil;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.mail.MailTestSetup;
import org.subethamail.wiser.Wiser;
import org.subethamail.wiser.WiserMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachmentTest
extends JbpmTestCase {
    private static Wiser wiser = new Wiser();

    protected void tearDown() throws Exception {
        wiser.getMessages().clear();
        super.tearDown();
    }

    public static Test suite() {
        return new MailTestSetup(AttachmentTest.class, wiser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVariableAttachment() throws MessagingException, IOException {
        this.deployJpdlXmlString("<process name='varattachment'>  <start>    <transition to='send mail' />  </start>  <mail name='send mail'>    <to addresses='dilbert@office' />    <subject>review</subject>    <text>did you review the document I emailed?</text>    <attachments>      <attachment name='strip.gif' expression='${strip}' mime-type='image/gif'/>    </attachments>    <transition to='end' />  </mail>  <end name='end'/></process>");
        InputStream resourceStream = ((Object)((Object)this)).getClass().getResourceAsStream("strip.gif");
        try {
            byte[] strip = IoUtil.readBytes((InputStream)resourceStream);
            ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("varattachment", Collections.singletonMap("strip", strip));
            this.assertProcessInstanceEnded(processInstance);
            AttachmentTest.examineMessages(wiser.getMessages());
        }
        finally {
            IoUtil.close((Closeable)resourceStream);
        }
    }

    public void testFileAttachment() throws MessagingException, IOException, URISyntaxException {
        File file = new File(((Object)((Object)this)).getClass().getResource("strip.gif").toURI());
        this.deployJpdlXmlString("<process name='fileattachment'>  <start>    <transition to='send mail' />  </start>  <mail name='send mail'>    <to addresses='dilbert@office' />    <subject>review</subject>    <text>did you review the document I emailed?</text>    <attachments>      <attachment file='" + file + "'/>" + "    </attachments>" + "    <transition to='end' />" + "  </mail>" + "  <end name='end'/>" + "</process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("fileattachment");
        this.assertProcessInstanceEnded(processInstance);
        AttachmentTest.examineMessages(wiser.getMessages());
    }

    public void testUrlAttachment() throws MessagingException, IOException {
        URL url = ((Object)((Object)this)).getClass().getResource("strip.gif");
        this.deployJpdlXmlString("<process name='urlattachment'>  <start>    <transition to='send mail' />  </start>  <mail name='send mail'>    <to addresses='dilbert@office' />    <subject>review</subject>    <text>did you review the document I emailed?</text>    <attachments>      <attachment url='" + url + "'/>" + "    </attachments>" + "    <transition to='end' />" + "  </mail>" + "  <end name='end'/>" + "</process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("urlattachment");
        this.assertProcessInstanceEnded(processInstance);
        AttachmentTest.examineMessages(wiser.getMessages());
    }

    public void testResourceAttachment() throws MessagingException, IOException {
        this.deployJpdlXmlString("<process name='resattachment'>  <start>    <transition to='send mail' />  </start>  <mail name='send mail'>    <to addresses='dilbert@office' />    <subject>review</subject>    <text>did you review the document I emailed?</text>    <attachments>      <attachment resource='org/jbpm/test/activity/mail/strip.gif'/>    </attachments>    <transition to='end' />  </mail>  <end name='end'/></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("resattachment");
        this.assertProcessInstanceEnded(processInstance);
        AttachmentTest.examineMessages(wiser.getMessages());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void examineMessages(List<WiserMessage> wiserMessages) throws MessagingException, IOException {
        AttachmentTest.assertEquals((int)1, (int)wiserMessages.size());
        WiserMessage wisMessage = wiserMessages.get(0);
        MimeMessage message = wisMessage.getMimeMessage();
        Multipart multipart = (Multipart)message.getContent();
        AttachmentTest.assertEquals((int)2, (int)multipart.getCount());
        BodyPart textPart = multipart.getBodyPart(0);
        assert (textPart.getContentType().startsWith("text/plain")) : textPart.getContentType();
        AttachmentTest.assertEquals((Object)"did you review the document I emailed?", (Object)textPart.getContent());
        BodyPart gifPart = multipart.getBodyPart(1);
        AttachmentTest.assertEquals((String)"strip.gif", (String)gifPart.getFileName());
        assert (gifPart.getContentType().startsWith("image/gif")) : gifPart.getContentType();
        InputStream gifStream = gifPart.getInputStream();
        try {
            AttachmentTest.assertEquals((int)71, (int)gifStream.read());
            AttachmentTest.assertEquals((int)73, (int)gifStream.read());
            AttachmentTest.assertEquals((int)70, (int)gifStream.read());
        }
        finally {
            gifStream.close();
        }
    }
}

