/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activity.forkjoin;

import java.util.HashMap;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.history.HistoryProcessInstance;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;

public class ForkJoinWithMutliplicityTest
extends JbpmTestCase {
    public void testForkWithMultiplicityOne() {
        this.deployJpdlXmlString("<process name='ForkJoingMultiplicity' xmlns='http://jbpm.org/4.3/jpdl'>   <start g='179,17,32,29' name='start1'>      <transition g='-43,-18' name='to fork1' to='fork1'/>   </start>   <fork g='185,95,49,50' name='fork1' >      <transition name='left' to='task1' g='-44,-18'/>      <transition name='right' to='task2' g='-44,-18'/>   </fork>   <task name='task1' g='90,177,73,44' assignee='mike'>      <transition name='to join1' to='join1' g='-43,-18'/>   </task>   <task name='task2' g='90,177,73,44' assignee='alex'>      <transition name='to join1' to='join1' g='-43,-18'/>   </task>   <join name='join1' g='192,511,57,44' multiplicity='1'>      <transition name='to Big car' to='Big car' g='-42,-18'/>   </join>   <state name='Big car' >      <transition name='to end1' to='end1' g='-43,-18'/>   </state>    <end g='193,606,38,33' name='end1'/></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("ForkJoingMultiplicity");
        Task taskAlex = this.taskService.createTaskQuery().assignee("alex").uniqueResult();
        ForkJoinWithMutliplicityTest.assertNotNull((Object)taskAlex);
        ForkJoinWithMutliplicityTest.assertEquals((String)"task2", (String)taskAlex.getActivityName());
        this.taskService.completeTask(taskAlex.getId());
        processInstance = this.executionService.findProcessInstanceById(processInstance.getId());
        this.executionService.signalExecutionById(processInstance.getId());
        HistoryProcessInstance history = this.historyService.createHistoryProcessInstanceQuery().processInstanceId(processInstance.getId()).uniqueResult();
        ForkJoinWithMutliplicityTest.assertNotNull((Object)history);
        ForkJoinWithMutliplicityTest.assertEquals((String)"ended", (String)history.getState());
        ForkJoinWithMutliplicityTest.assertEquals((String)"end1", (String)history.getEndActivityName());
    }

    public void testForkWithMultiplicityAsExpression() {
        this.deployJpdlXmlString("<process name='ForkJoingMultiplicity' xmlns='http://jbpm.org/4.3/jpdl'>   <start g='179,17,32,29' name='start1'>      <transition g='-43,-18' name='to fork1' to='fork1'/>   </start>   <fork g='185,95,49,50' name='fork1' >      <transition name='left' to='task1' g='-44,-18'/>      <transition name='right' to='task2' g='-44,-18'/>   </fork>   <task name='task1' g='90,177,73,44' assignee='mike'>      <transition name='to join1' to='join1' g='-43,-18'/>   </task>   <task name='task2' g='90,177,73,44' assignee='alex'>      <transition name='to join1' to='join1' g='-43,-18'/>   </task>   <join name='join1' g='192,511,57,44' multiplicity='#{multiplicity}'>      <transition name='to Big car' to='Big car' g='-42,-18'/>   </join>   <state name='Big car' >      <transition name='to end1' to='end1' g='-43,-18'/>   </state>    <end g='193,606,38,33' name='end1'/></process>");
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("multiplicity", 1);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("ForkJoingMultiplicity", variables);
        Task taskAlex = this.taskService.createTaskQuery().assignee("alex").uniqueResult();
        ForkJoinWithMutliplicityTest.assertNotNull((Object)taskAlex);
        ForkJoinWithMutliplicityTest.assertEquals((String)"task2", (String)taskAlex.getActivityName());
        this.taskService.completeTask(taskAlex.getId());
        processInstance = this.executionService.findProcessInstanceById(processInstance.getId());
        this.executionService.signalExecutionById(processInstance.getId());
        HistoryProcessInstance history = this.historyService.createHistoryProcessInstanceQuery().processInstanceId(processInstance.getId()).uniqueResult();
        ForkJoinWithMutliplicityTest.assertNotNull((Object)history);
        ForkJoinWithMutliplicityTest.assertEquals((String)"ended", (String)history.getState());
        ForkJoinWithMutliplicityTest.assertEquals((String)"end1", (String)history.getEndActivityName());
    }
}

