/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activities;

import java.util.List;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;

public class ForkToTaskTest
extends JbpmTestCase {
    public void testForkToTasks() {
        this.deployJpdlXmlString("<process name='ForkToTasks'>  <start>    <transition to='f' />  </start>  <fork name='f'>    <transition to='assemble product' />    <transition to='print documents' />  </fork>  <task name='assemble product' assignee='johndoe'>    <transition to='j' />  </task>  <task name='print documents' assignee='johndoe'>    <transition to='j' />  </task>  <join name='j'>    <transition to='end' />  </join>  <end name='end' /></process>");
        this.executionService.startProcessInstanceByKey("ForkToTasks");
    }

    public void testForkWithUnfinishedPath() {
        this.deployJpdlXmlString("<process name='forkTest'>  <start name='start1'>    <transition to='fork'/>  </start>  <fork name='fork'>    <transition name='review1' to='review1'/>    <transition name='review2' to='review2'/>    <transition name='control1' to='control'/>  </fork>  <task candidate-users='requester' name='review1'>    <transition name='Approve' to='join'/>    <transition name='Reject' to='rejected1'/>  </task>  <task candidate-users='requester' name='review2'>    <transition name='Approve' to='join'/>    <transition name='Reject' to='rejected2'/>  </task>  <task candidate-groups='control' name='control' />  <join name='join'>    <transition to='end'/>  </join>  <end name='end'/>  <end-cancel name='rejected2'/>  <end-cancel name='rejected1'/></process>");
        String processInstanceId = this.executionService.startProcessInstanceByKey("forkTest").getId();
        List tasks = this.taskService.createTaskQuery().processInstanceId(processInstanceId).list();
        ForkToTaskTest.assertEquals((int)3, (int)tasks.size());
        String requester = "requester";
        List tasksForRequester = this.taskService.findGroupTasks("requester");
        ForkToTaskTest.assertEquals((int)2, (int)tasksForRequester.size());
        for (Task task : tasksForRequester) {
            this.taskService.takeTask(task.getId(), "requester");
            this.taskService.completeTask(task.getId(), "Approve");
        }
        this.assertProcessInstanceEnded(processInstanceId);
    }
}

