/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.rulesdecision;

import java.util.HashMap;
import org.jbpm.api.ProcessInstance;
import org.jbpm.test.JbpmTestCase;

public class RulesDecisionTest
extends JbpmTestCase {
    String deploymentId;

    protected void setUp() throws Exception {
        super.setUp();
        this.deploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/examples/rulesdecision/process.jpdl.xml").addResourceFromClasspath("org/jbpm/examples/rulesdecision/rules.drl").deploy();
    }

    protected void tearDown() throws Exception {
        this.repositoryService.deleteDeploymentCascade(this.deploymentId);
        super.tearDown();
    }

    public void testImportantOrder() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("amount", 32);
        variables.put("product", "shoe");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("RulesDecision", variables);
        RulesDecisionTest.assertTrue((boolean)processInstance.isActive("processWithPriority"));
    }

    public void testIrrelevantOrder() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("amount", 2);
        variables.put("product", "missiles");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("RulesDecision", variables);
        RulesDecisionTest.assertTrue((boolean)processInstance.isActive("processWhenResourcesAvailable"));
    }

    public void testUndefinedImportance() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("amount", 15);
        variables.put("product", "shoe");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("RulesDecision", variables);
        RulesDecisionTest.assertTrue((boolean)processInstance.isActive("analyseManually"));
    }

    public void test13TempranillosIsImportant() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("amount", 13);
        variables.put("product", "Tempranillo");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("RulesDecision", variables);
        RulesDecisionTest.assertTrue((boolean)processInstance.isActive("processWithPriority"));
    }
}

