/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn.test.intermediatecatch;

import java.util.Collection;
import java.util.Date;
import org.jbpm.api.JbpmException;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.job.Job;
import org.jbpm.pvm.internal.util.Clock;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.assertion.CollectionAssertions;
import org.jbpm.test.util.DateUtils;

public class IntermediateCatchTimerEventTest
extends JbpmTestCase {
    private static final String BAD_PROCESS_1 = "<definitions xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'>  <process id='intermediateCatchEvent'>    <startEvent id='theStart' />    <sequenceFlow id='flow1' sourceRef='theStart' targetRef='intermediateTimer' />    <intermediateCatchEvent id='intermediateTimer' >      <timerEventDefinition/>    </intermediateCatchEvent>    <sequenceFlow id='flow2' sourceRef='intermediateTimer' targetRef='theEnd' />    <endEvent id='theEnd' />  </process></definitions>";
    private static final String BAD_PROCESS_2 = "<definitions xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'>  <process id='intermediateCatchEvent'>    <startEvent id='theStart' />    <sequenceFlow id='flow1' sourceRef='theStart' targetRef='intermediateTimer' />    <intermediateCatchEvent id='intermediateTimer' >      <timerEventDefinition>        <timeCycle>5 hours</timeCycle>        <timeDate>10/10/1985</timeDate>      </timerEventDefinition>    </intermediateCatchEvent>    <sequenceFlow id='flow2' sourceRef='intermediateTimer' targetRef='theEnd' />    <endEvent id='theEnd' />  </process></definitions>";
    private static final String TIMER_CATCH_WITH_TIMECYCLE_DURATION = "<definitions xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'>  <process id='timeCycleProcess'>    <startEvent id='theStart' />    <sequenceFlow id='flow1' sourceRef='theStart' targetRef='intermediateTimer' />    <intermediateCatchEvent id='intermediateTimer' >      <timerEventDefinition>        <timeCycle>5 hours</timeCycle>      </timerEventDefinition>    </intermediateCatchEvent>    <sequenceFlow id='flow2' sourceRef='intermediateTimer' targetRef='theEnd' />    <endEvent id='theEnd' />  </process></definitions>";
    private static final String TIMER_CATCH_WITH_TIMEDATE = "<definitions xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'>  <process id='timeDateProcess'>    <startEvent id='theStart' />    <sequenceFlow id='flow1' sourceRef='theStart' targetRef='intermediateTimer' />    <intermediateCatchEvent id='intermediateTimer' >      <timerEventDefinition>        <timeDate>10/10/2099 00:00:00</timeDate>      </timerEventDefinition>    </intermediateCatchEvent>    <sequenceFlow id='flow2' sourceRef='intermediateTimer' targetRef='theEnd' />    <endEvent id='theEnd' />  </process></definitions>";
    private static final String TIMER_CATCH_WITH_CRON_EXPRESSION = "<definitions xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'>  <process id='timeDateProcess'>    <startEvent id='theStart' />    <sequenceFlow id='flow1' sourceRef='theStart' targetRef='intermediateTimer' />    <intermediateCatchEvent id='intermediateTimer' >      <timerEventDefinition>        <timeCycle>0 * * * * ?</timeCycle>      </timerEventDefinition>    </intermediateCatchEvent>    <sequenceFlow id='flow2' sourceRef='intermediateTimer' targetRef='theEnd' />    <endEvent id='theEnd' />  </process></definitions>";
    private static final String TIMER_CATCH_WITH_CRON_EXPRESSION_2 = "<definitions xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'>  <process id='timeDateProcess'>    <startEvent id='theStart' />    <sequenceFlow id='flow1' sourceRef='theStart' targetRef='intermediateTimer' />    <intermediateCatchEvent id='intermediateTimer' >      <timerEventDefinition>        <timeCycle>0 0 23 ? * FRI</timeCycle>      </timerEventDefinition>    </intermediateCatchEvent>    <sequenceFlow id='flow2' sourceRef='intermediateTimer' targetRef='theEnd' />    <endEvent id='theEnd' />  </process></definitions>";

    protected void tearDown() throws Exception {
        Clock.setExplicitTime(null);
        super.tearDown();
    }

    public void testInvalidProcess() {
        String expectedMsg = "requires either a timeDate or a timeCycle definition (but not both)";
        try {
            this.deployBpmn2XmlString(BAD_PROCESS_1);
            IntermediateCatchTimerEventTest.fail();
        }
        catch (JbpmException e) {
            IntermediateCatchTimerEventTest.assertTrue((boolean)e.getMessage().contains("requires either a timeDate or a timeCycle definition (but not both)"));
        }
        try {
            this.deployBpmn2XmlString(BAD_PROCESS_2);
            IntermediateCatchTimerEventTest.fail();
        }
        catch (JbpmException e) {
            IntermediateCatchTimerEventTest.assertTrue((boolean)e.getMessage().contains("requires either a timeDate or a timeCycle definition (but not both)"));
        }
    }

    public void testTimeCycleExpression() {
        this.deployBpmn2XmlString(TIMER_CATCH_WITH_TIMECYCLE_DURATION);
        long processStartTime = 5000L;
        Clock.setExplicitTime((Date)new Date(processStartTime));
        ProcessInstance pi = this.executionService.startProcessInstanceByKey("timeCycleProcess");
        CollectionAssertions.assertContainsSameElements((Collection)pi.findActiveActivityNames(), (Object[])new String[]{"intermediateTimer"});
        Job timerJob = this.managementService.createJobQuery().processInstanceId(pi.getId()).uniqueResult();
        long expectedTimerDueDate = processStartTime + 18000000L;
        IntermediateCatchTimerEventTest.assertEquals((long)expectedTimerDueDate, (long)timerJob.getDueDate().getTime());
        this.managementService.executeJob(timerJob.getId());
        this.assertProcessInstanceEnded(pi);
    }

    public void testTimeDateExpression() {
        this.deployBpmn2XmlString(TIMER_CATCH_WITH_TIMEDATE);
        ProcessInstance pi = this.executionService.startProcessInstanceByKey("timeDateProcess");
        CollectionAssertions.assertContainsSameElements((Collection)pi.findActiveActivityNames(), (Object[])new String[]{"intermediateTimer"});
        Job timerJob = this.managementService.createJobQuery().processInstanceId(pi.getId()).uniqueResult();
        Date expectedDueDate = DateUtils.getDateAtMidnight((int)10, (int)9, (int)2099);
        IntermediateCatchTimerEventTest.assertEquals((long)expectedDueDate.getTime(), (long)timerJob.getDueDate().getTime());
        this.managementService.executeJob(timerJob.getId());
        this.assertProcessInstanceEnded(pi);
    }

    public void testCronExpression() {
        this.deployBpmn2XmlString(TIMER_CATCH_WITH_CRON_EXPRESSION);
        Clock.setExplicitTime((Date)DateUtils.getDate((int)20, (int)0, (int)2010, (int)0, (int)1, (int)1));
        ProcessInstance pi = this.executionService.startProcessInstanceByKey("timeDateProcess");
        CollectionAssertions.assertContainsSameElements((Collection)pi.findActiveActivityNames(), (Object[])new String[]{"intermediateTimer"});
        Job timerJob = this.managementService.createJobQuery().processInstanceId(pi.getId()).uniqueResult();
        IntermediateCatchTimerEventTest.assertEquals((long)DateUtils.getDate((int)20, (int)0, (int)2010, (int)0, (int)2, (int)0).getTime(), (long)timerJob.getDueDate().getTime());
        this.managementService.executeJob(timerJob.getId());
        this.assertProcessInstanceEnded(pi);
    }

    public void testCronExpression2() {
        this.deployBpmn2XmlString(TIMER_CATCH_WITH_CRON_EXPRESSION_2);
        Clock.setExplicitTime((Date)DateUtils.getDateAtMidnight((int)21, (int)0, (int)2010));
        ProcessInstance pi = this.executionService.startProcessInstanceByKey("timeDateProcess");
        CollectionAssertions.assertContainsSameElements((Collection)pi.findActiveActivityNames(), (Object[])new String[]{"intermediateTimer"});
        Job timerJob = this.managementService.createJobQuery().processInstanceId(pi.getId()).uniqueResult();
        IntermediateCatchTimerEventTest.assertEquals((long)DateUtils.getDate((int)22, (int)0, (int)2010, (int)23, (int)0, (int)0).getTime(), (long)timerJob.getDueDate().getTime());
        this.managementService.executeJob(timerJob.getId());
        this.assertProcessInstanceEnded(pi);
    }
}

