/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.InstanceCreator;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonDeserializerExceptionWrapper;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSerializerExceptionWrapper;
import com.google.gson.ParameterizedTypeHandlerMap;
import com.google.gson.TypeInfoMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DefaultTypeAdapters {
    private static final DefaultDateTypeAdapter DATE_TYPE_ADAPTER = new DefaultDateTypeAdapter(DateFormat.getDateTimeInstance());
    private static final EnumTypeAdapter ENUM_TYPE_ADAPTER = new EnumTypeAdapter();
    private static final UrlTypeAdapter URL_TYPE_ADAPTER = new UrlTypeAdapter();
    private static final UriTypeAdapter URI_TYPE_ADAPTER = new UriTypeAdapter();
    private static final LocaleTypeAdapter LOCALE_TYPE_ADAPTER = new LocaleTypeAdapter();
    private static final MapTypeAdapter MAP_TYPE_ADAPTER = new MapTypeAdapter();
    private static final BigDecimalTypeAdapter BIG_DECIMAL_TYPE_ADAPTER = new BigDecimalTypeAdapter();
    private static final BigIntegerTypeAdapter BIG_INTEGER_TYPE_ADAPTER = new BigIntegerTypeAdapter();
    private static final BooleanCreator BOOLEAN_CREATOR = new BooleanCreator();
    private static final ByteCreator BYTE_CREATOR = new ByteCreator();
    private static final CharacterCreator CHARACTER_CREATOR = new CharacterCreator();
    private static final DoubleCreator DOUBLE_CREATOR = new DoubleCreator();
    private static final FloatCreator FLOAT_CREATOR = new FloatCreator();
    private static final IntegerCreator INTEGER_CREATOR = new IntegerCreator();
    private static final LongCreator LONG_CREATOR = new LongCreator();
    private static final ShortCreator SHORT_CREATOR = new ShortCreator();
    private static final LinkedListCreator LINKED_LIST_CREATOR = new LinkedListCreator();
    private static final TreeSetCreator TREE_SET_CREATOR = new TreeSetCreator();
    static final ParameterizedTypeHandlerMap<JsonSerializer<?>> DEFAULT_SERIALIZERS = DefaultTypeAdapters.getDefaultSerializers();
    static final ParameterizedTypeHandlerMap<JsonDeserializer<?>> DEFAULT_DESERIALIZERS = DefaultTypeAdapters.getDefaultDeserializers();
    static final ParameterizedTypeHandlerMap<InstanceCreator<?>> DEFAULT_INSTANCE_CREATORS = DefaultTypeAdapters.getDefaultInstanceCreators();

    DefaultTypeAdapters() {
    }

    private static ParameterizedTypeHandlerMap<JsonSerializer<?>> getDefaultSerializers() {
        ParameterizedTypeHandlerMap map = new ParameterizedTypeHandlerMap();
        map.register((Type)((Object)Enum.class), DefaultTypeAdapters.wrapSerializer(ENUM_TYPE_ADAPTER));
        map.register((Type)((Object)URL.class), DefaultTypeAdapters.wrapSerializer(URL_TYPE_ADAPTER));
        map.register((Type)((Object)URI.class), DefaultTypeAdapters.wrapSerializer(URI_TYPE_ADAPTER));
        map.register((Type)((Object)Locale.class), DefaultTypeAdapters.wrapSerializer(LOCALE_TYPE_ADAPTER));
        map.register((Type)((Object)Map.class), DefaultTypeAdapters.wrapSerializer(MAP_TYPE_ADAPTER));
        map.register((Type)((Object)Date.class), DefaultTypeAdapters.wrapSerializer(DATE_TYPE_ADAPTER));
        map.register((Type)((Object)BigDecimal.class), DefaultTypeAdapters.wrapSerializer(BIG_DECIMAL_TYPE_ADAPTER));
        map.register((Type)((Object)BigInteger.class), DefaultTypeAdapters.wrapSerializer(BIG_INTEGER_TYPE_ADAPTER));
        map.makeUnmodifiable();
        return map;
    }

    private static ParameterizedTypeHandlerMap<JsonDeserializer<?>> getDefaultDeserializers() {
        ParameterizedTypeHandlerMap map = new ParameterizedTypeHandlerMap();
        map.register((Type)((Object)Enum.class), DefaultTypeAdapters.wrapDeserializer(ENUM_TYPE_ADAPTER));
        map.register((Type)((Object)URL.class), DefaultTypeAdapters.wrapDeserializer(URL_TYPE_ADAPTER));
        map.register((Type)((Object)URI.class), DefaultTypeAdapters.wrapDeserializer(URI_TYPE_ADAPTER));
        map.register((Type)((Object)Locale.class), DefaultTypeAdapters.wrapDeserializer(LOCALE_TYPE_ADAPTER));
        map.register((Type)((Object)Map.class), DefaultTypeAdapters.wrapDeserializer(MAP_TYPE_ADAPTER));
        map.register((Type)((Object)Date.class), DefaultTypeAdapters.wrapDeserializer(DATE_TYPE_ADAPTER));
        map.register((Type)((Object)BigDecimal.class), DefaultTypeAdapters.wrapDeserializer(BIG_DECIMAL_TYPE_ADAPTER));
        map.register((Type)((Object)BigInteger.class), DefaultTypeAdapters.wrapDeserializer(BIG_INTEGER_TYPE_ADAPTER));
        map.makeUnmodifiable();
        return map;
    }

    private static ParameterizedTypeHandlerMap<InstanceCreator<?>> getDefaultInstanceCreators() {
        ParameterizedTypeHandlerMap map = new ParameterizedTypeHandlerMap();
        map.register((Type)((Object)Enum.class), ENUM_TYPE_ADAPTER);
        map.register((Type)((Object)URL.class), URL_TYPE_ADAPTER);
        map.register((Type)((Object)Locale.class), LOCALE_TYPE_ADAPTER);
        map.register((Type)((Object)Map.class), MAP_TYPE_ADAPTER);
        map.register((Type)((Object)BigDecimal.class), BIG_DECIMAL_TYPE_ADAPTER);
        map.register((Type)((Object)BigInteger.class), BIG_INTEGER_TYPE_ADAPTER);
        map.register((Type)((Object)Boolean.class), BOOLEAN_CREATOR);
        map.register(Boolean.TYPE, BOOLEAN_CREATOR);
        map.register((Type)((Object)Byte.class), BYTE_CREATOR);
        map.register(Byte.TYPE, BYTE_CREATOR);
        map.register((Type)((Object)Character.class), CHARACTER_CREATOR);
        map.register(Character.TYPE, CHARACTER_CREATOR);
        map.register((Type)((Object)Double.class), DOUBLE_CREATOR);
        map.register(Double.TYPE, DOUBLE_CREATOR);
        map.register((Type)((Object)Float.class), FLOAT_CREATOR);
        map.register(Float.TYPE, FLOAT_CREATOR);
        map.register((Type)((Object)Integer.class), INTEGER_CREATOR);
        map.register(Integer.TYPE, INTEGER_CREATOR);
        map.register((Type)((Object)Long.class), LONG_CREATOR);
        map.register(Long.TYPE, LONG_CREATOR);
        map.register((Type)((Object)Short.class), SHORT_CREATOR);
        map.register(Short.TYPE, SHORT_CREATOR);
        map.register((Type)((Object)Collection.class), LINKED_LIST_CREATOR);
        map.register((Type)((Object)List.class), LINKED_LIST_CREATOR);
        map.register((Type)((Object)Queue.class), LINKED_LIST_CREATOR);
        map.register((Type)((Object)Set.class), TREE_SET_CREATOR);
        map.register((Type)((Object)SortedSet.class), TREE_SET_CREATOR);
        map.makeUnmodifiable();
        return map;
    }

    private static JsonSerializer<?> wrapSerializer(JsonSerializer<?> serializer) {
        return new JsonSerializerExceptionWrapper(serializer);
    }

    private static JsonDeserializer<?> wrapDeserializer(JsonDeserializer<?> deserializer) {
        return new JsonDeserializerExceptionWrapper(deserializer);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TreeSetCreator
    implements InstanceCreator<TreeSet<?>> {
        private TreeSetCreator() {
        }

        @Override
        public TreeSet<?> createInstance(Type type) {
            return new TreeSet();
        }

        public String toString() {
            return TreeSetCreator.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LinkedListCreator
    implements InstanceCreator<LinkedList<?>> {
        private LinkedListCreator() {
        }

        @Override
        public LinkedList<?> createInstance(Type type) {
            return new LinkedList();
        }

        public String toString() {
            return LinkedListCreator.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BooleanCreator
    implements InstanceCreator<Boolean> {
        private BooleanCreator() {
        }

        @Override
        public Boolean createInstance(Type type) {
            return new Boolean(false);
        }

        public String toString() {
            return BooleanCreator.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CharacterCreator
    implements InstanceCreator<Character> {
        private CharacterCreator() {
        }

        @Override
        public Character createInstance(Type type) {
            return new Character('\u0000');
        }

        public String toString() {
            return CharacterCreator.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DoubleCreator
    implements InstanceCreator<Double> {
        private DoubleCreator() {
        }

        @Override
        public Double createInstance(Type type) {
            return new Double(0.0);
        }

        public String toString() {
            return DoubleCreator.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FloatCreator
    implements InstanceCreator<Float> {
        private FloatCreator() {
        }

        @Override
        public Float createInstance(Type type) {
            return new Float(0.0f);
        }

        public String toString() {
            return FloatCreator.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ByteCreator
    implements InstanceCreator<Byte> {
        private ByteCreator() {
        }

        @Override
        public Byte createInstance(Type type) {
            return new Byte(0);
        }

        public String toString() {
            return ByteCreator.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ShortCreator
    implements InstanceCreator<Short> {
        private ShortCreator() {
        }

        @Override
        public Short createInstance(Type type) {
            return new Short(0);
        }

        public String toString() {
            return ShortCreator.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntegerCreator
    implements InstanceCreator<Integer> {
        private IntegerCreator() {
        }

        @Override
        public Integer createInstance(Type type) {
            return new Integer(0);
        }

        public String toString() {
            return IntegerCreator.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LongCreator
    implements InstanceCreator<Long> {
        private LongCreator() {
        }

        @Override
        public Long createInstance(Type type) {
            return new Long(0L);
        }

        public String toString() {
            return LongCreator.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BigIntegerTypeAdapter
    implements JsonSerializer<BigInteger>,
    JsonDeserializer<BigInteger>,
    InstanceCreator<BigInteger> {
        private BigIntegerTypeAdapter() {
        }

        @Override
        public JsonElement serialize(BigInteger src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src);
        }

        @Override
        public BigInteger deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return json.getAsBigInteger();
        }

        @Override
        public BigInteger createInstance(Type type) {
            return new BigInteger("0");
        }

        public String toString() {
            return BigIntegerTypeAdapter.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BigDecimalTypeAdapter
    implements JsonSerializer<BigDecimal>,
    JsonDeserializer<BigDecimal>,
    InstanceCreator<BigDecimal> {
        private BigDecimalTypeAdapter() {
        }

        @Override
        public JsonElement serialize(BigDecimal src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src);
        }

        @Override
        public BigDecimal deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return json.getAsBigDecimal();
        }

        @Override
        public BigDecimal createInstance(Type type) {
            return new BigDecimal(0);
        }

        public String toString() {
            return BigDecimalTypeAdapter.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MapTypeAdapter
    implements JsonSerializer<Map>,
    JsonDeserializer<Map>,
    InstanceCreator<Map> {
        MapTypeAdapter() {
        }

        @Override
        public JsonElement serialize(Map src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject map = new JsonObject();
            Type childType = new TypeInfoMap(typeOfSrc).getValueType();
            for (Map.Entry entry : src.entrySet()) {
                JsonElement valueElement = context.serialize(entry.getValue(), childType);
                map.add(entry.getKey().toString(), valueElement);
            }
            return map;
        }

        @Override
        public Map deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            LinkedHashMap map = new LinkedHashMap();
            Type childType = new TypeInfoMap(typeOfT).getValueType();
            for (Map.Entry<String, JsonElement> entry : json.getAsJsonObject().entrySet()) {
                Object value = context.deserialize(entry.getValue(), childType);
                map.put(entry.getKey(), value);
            }
            return map;
        }

        @Override
        public Map createInstance(Type type) {
            return new LinkedHashMap();
        }

        public String toString() {
            return MapTypeAdapter.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocaleTypeAdapter
    implements JsonSerializer<Locale>,
    JsonDeserializer<Locale>,
    InstanceCreator<Locale> {
        private LocaleTypeAdapter() {
        }

        @Override
        public JsonElement serialize(Locale src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toString());
        }

        @Override
        public Locale deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String locale = json.getAsString();
            StringTokenizer tokenizer = new StringTokenizer(locale, "_");
            String language = null;
            String country = null;
            String variant = null;
            if (tokenizer.hasMoreElements()) {
                language = tokenizer.nextToken();
            }
            if (tokenizer.hasMoreElements()) {
                country = tokenizer.nextToken();
            }
            if (tokenizer.hasMoreElements()) {
                variant = tokenizer.nextToken();
            }
            if (country == null && variant == null) {
                return new Locale(language);
            }
            if (variant == null) {
                return new Locale(language, country);
            }
            return new Locale(language, country, variant);
        }

        @Override
        public Locale createInstance(Type type) {
            return new Locale("en_US");
        }

        public String toString() {
            return LocaleTypeAdapter.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UriTypeAdapter
    implements JsonSerializer<URI>,
    JsonDeserializer<URI> {
        private UriTypeAdapter() {
        }

        @Override
        public JsonElement serialize(URI src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toASCIIString());
        }

        @Override
        public URI deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                return new URI(json.getAsString());
            }
            catch (URISyntaxException e) {
                throw new JsonParseException(e);
            }
        }

        public String toString() {
            return UriTypeAdapter.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UrlTypeAdapter
    implements JsonSerializer<URL>,
    JsonDeserializer<URL>,
    InstanceCreator<URL> {
        private UrlTypeAdapter() {
        }

        @Override
        public JsonElement serialize(URL src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toExternalForm());
        }

        @Override
        public URL deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                return new URL(json.getAsString());
            }
            catch (MalformedURLException e) {
                throw new JsonParseException(e);
            }
        }

        @Override
        public URL createInstance(Type type) {
            try {
                return new URL("http://google.com/");
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return UrlTypeAdapter.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnumTypeAdapter<T extends Enum<T>>
    implements JsonSerializer<T>,
    JsonDeserializer<T>,
    InstanceCreator<Enum<?>> {
        private EnumTypeAdapter() {
        }

        @Override
        public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(((Enum)src).name());
        }

        @Override
        public T deserialize(JsonElement json, Type classOfT, JsonDeserializationContext context) throws JsonParseException {
            return Enum.valueOf((Class)classOfT, json.getAsString());
        }

        @Override
        public Enum<?> createInstance(Type type) {
            Class enumClass = (Class)type;
            try {
                Method valuesMethod = enumClass.getMethod("values", new Class[0]);
                Enum[] enums = (Enum[])valuesMethod.invoke(null, new Object[0]);
                return enums[0];
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return EnumTypeAdapter.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DefaultDateTypeAdapter
    implements JsonSerializer<Date>,
    JsonDeserializer<Date> {
        private final DateFormat format;

        public DefaultDateTypeAdapter(String datePattern) {
            this.format = new SimpleDateFormat(datePattern);
        }

        DefaultDateTypeAdapter(DateFormat format) {
            this.format = format;
        }

        public DefaultDateTypeAdapter(int style) {
            this.format = DateFormat.getDateInstance(style);
        }

        public DefaultDateTypeAdapter(int dateStyle, int timeStyle) {
            this.format = DateFormat.getDateTimeInstance(dateStyle, timeStyle);
        }

        @Override
        public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
            String dateFormatAsString = this.format.format(src);
            return new JsonPrimitive(dateFormatAsString);
        }

        @Override
        public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (!(json instanceof JsonPrimitive)) {
                throw new JsonParseException("The date should be a string value");
            }
            try {
                return this.format.parse(json.getAsString());
            }
            catch (ParseException e) {
                throw new JsonParseException(e);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(DefaultDateTypeAdapter.class.getSimpleName());
            sb.append('(').append(this.format.getClass().getSimpleName()).append(')');
            return sb.toString();
        }
    }
}

