/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;
import org.drools.RuleBaseConfiguration;
import org.drools.common.BaseNode;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSinkNode;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.TerminalNode;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.GroupElement;
import org.drools.rule.Rule;
import org.drools.spi.PropagationContext;

public final class QueryTerminalNode
extends BaseNode
implements LeftTupleSinkNode,
NodeMemory,
TerminalNode {
    private static final long serialVersionUID = 400L;
    public static final short type = 8;
    private Rule rule;
    private GroupElement subrule;
    private LeftTupleSource tupleSource;
    private boolean tupleMemoryEnabled;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;

    public QueryTerminalNode() {
    }

    public QueryTerminalNode(int id, LeftTupleSource source, Rule rule, GroupElement subrule, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation());
        this.rule = rule;
        this.subrule = subrule;
        this.tupleSource = source;
        this.tupleMemoryEnabled = false;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.rule = (Rule)in.readObject();
        this.subrule = (GroupElement)in.readObject();
        this.tupleSource = (LeftTupleSource)in.readObject();
        this.tupleMemoryEnabled = in.readBoolean();
        this.previousTupleSinkNode = (LeftTupleSinkNode)in.readObject();
        this.nextTupleSinkNode = (LeftTupleSinkNode)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.rule);
        out.writeObject(this.subrule);
        out.writeObject(this.tupleSource);
        out.writeBoolean(this.tupleMemoryEnabled);
        out.writeObject(this.previousTupleSinkNode);
        out.writeObject(this.nextTupleSinkNode);
    }

    public Rule getRule() {
        return this.rule;
    }

    public void assertLeftTuple(LeftTuple tuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        LinkedList list = (LinkedList)workingMemory.getNodeMemory(this);
        if (list.isEmpty()) {
            ((ReteooWorkingMemory)workingMemory).setQueryResults(this.rule.getName(), this);
        }
        list.add(tuple);
    }

    public void retractLeftTuple(LeftTuple tuple, PropagationContext context, InternalWorkingMemory workingMemory) {
    }

    public String toString() {
        return "[QueryTerminalNode: rule=" + this.rule.getName() + "]";
    }

    public void ruleAttached() {
    }

    public void attach() {
        this.tupleSource.addTupleSink(this);
    }

    public void attach(InternalWorkingMemory[] workingMemories) {
        this.attach();
        for (InternalWorkingMemory workingMemory : workingMemories) {
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.tupleSource.updateSink(this, propagationContext, workingMemory);
        }
    }

    public void networkUpdated() {
        this.tupleSource.networkUpdated();
    }

    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, BaseNode node, InternalWorkingMemory[] workingMemories) {
        int length = workingMemories.length;
        for (int i = 0; i < length; ++i) {
            workingMemories[i].clearNodeMemory(this);
        }
        if (!context.alreadyVisited(this.tupleSource)) {
            this.tupleSource.remove(context, builder, this, workingMemories);
        }
    }

    public boolean isInUse() {
        return false;
    }

    public void updateNewNode(InternalWorkingMemory workingMemory, PropagationContext context) {
    }

    public Object createMemory(RuleBaseConfiguration config) {
        return new LinkedList();
    }

    public boolean isLeftTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    public GroupElement getSubrule() {
        return this.subrule;
    }

    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    public short getType() {
        return 8;
    }
}

