/*
 * Decompiled with CFR 0.152.
 */
package org.mockejb.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import org.mockejb.jms.MessageImpl;

public class BytesMessageImpl
extends MessageImpl
implements BytesMessage {
    private final ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
    private ByteArrayInputStream bytesIn;
    private DataInputStream dataIn;
    private DataOutputStream dataOut;

    public BytesMessageImpl() throws JMSException {
        this.clearBody();
    }

    public BytesMessageImpl(BytesMessage msg) throws JMSException {
        super((Message)msg);
        this.clearBody();
        this.setBody(msg);
    }

    private void setBody(BytesMessage msg) throws JMSException {
        int bytesRemaining = 0;
        byte[] sourceBytes = null;
        try {
            while (true) {
                msg.readByte();
                ++bytesRemaining;
            }
        }
        catch (MessageEOFException ex) {
            sourceBytes = this.extractBytes(msg);
            msg.reset();
            msg.readBytes(new byte[sourceBytes.length - bytesRemaining]);
        }
        catch (MessageNotReadableException ex) {
            sourceBytes = this.extractBytes(msg);
            msg.clearBody();
            msg.writeBytes(sourceBytes);
        }
        this.writeBytes(sourceBytes);
    }

    private byte[] extractBytes(BytesMessage msg) throws JMSException {
        msg.reset();
        int numberOfBytes = 0;
        try {
            while (true) {
                msg.readByte();
                ++numberOfBytes;
            }
        }
        catch (MessageEOFException ex) {
            byte[] result = new byte[numberOfBytes];
            msg.reset();
            msg.readBytes(result);
            return result;
        }
    }

    public void reset() {
        this.setBodyReadOnly();
        if (this.dataOut != null) {
            this.dataOut = null;
        }
        this.bytesIn = new ByteArrayInputStream(this.bytesOut.toByteArray());
        this.dataIn = new DataInputStream(this.bytesIn);
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        if (this.dataIn != null) {
            this.dataIn = null;
            this.bytesIn = null;
        }
        this.bytesOut.reset();
        this.dataOut = new DataOutputStream(this.bytesOut);
    }

    public long getBodyLength() throws JMSException {
        this.checkBodyReadable();
        return this.bytesOut.size();
    }

    public boolean readBoolean() throws JMSException {
        this.checkBodyReadable();
        try {
            return this.dataIn.readBoolean();
        }
        catch (EOFException ex) {
            throw new MessageEOFException(ex.getMessage());
        }
        catch (IOException ex) {
            throw new JMSException(ex.getMessage());
        }
    }

    public byte readByte() throws JMSException {
        this.checkBodyReadable();
        try {
            return this.dataIn.readByte();
        }
        catch (EOFException ex) {
            throw new MessageEOFException(ex.getMessage());
        }
        catch (IOException ex) {
            throw new JMSException(ex.getMessage());
        }
    }

    public int readUnsignedByte() throws JMSException {
        this.checkBodyReadable();
        try {
            return this.dataIn.readUnsignedByte();
        }
        catch (EOFException ex) {
            throw new MessageEOFException(ex.getMessage());
        }
        catch (IOException ex) {
            throw new JMSException(ex.getMessage());
        }
    }

    public short readShort() throws JMSException {
        this.checkBodyReadable();
        try {
            return this.dataIn.readShort();
        }
        catch (EOFException ex) {
            throw new MessageEOFException(ex.getMessage());
        }
        catch (IOException ex) {
            throw new JMSException(ex.getMessage());
        }
    }

    public int readUnsignedShort() throws JMSException {
        this.checkBodyReadable();
        try {
            return this.dataIn.readUnsignedShort();
        }
        catch (EOFException ex) {
            throw new MessageEOFException(ex.getMessage());
        }
        catch (IOException ex) {
            throw new JMSException(ex.getMessage());
        }
    }

    public char readChar() throws JMSException {
        this.checkBodyReadable();
        try {
            return this.dataIn.readChar();
        }
        catch (EOFException ex) {
            throw new MessageEOFException(ex.getMessage());
        }
        catch (IOException ex) {
            throw new JMSException(ex.getMessage());
        }
    }

    public int readInt() throws JMSException {
        this.checkBodyReadable();
        try {
            return this.dataIn.readInt();
        }
        catch (EOFException ex) {
            throw new MessageEOFException(ex.getMessage());
        }
        catch (IOException ex) {
            throw new JMSException(ex.getMessage());
        }
    }

    public long readLong() throws JMSException {
        this.checkBodyReadable();
        try {
            return this.dataIn.readLong();
        }
        catch (EOFException ex) {
            throw new MessageEOFException(ex.getMessage());
        }
        catch (IOException ex) {
            throw new JMSException(ex.getMessage());
        }
    }

    public float readFloat() throws JMSException {
        this.checkBodyReadable();
        try {
            return this.dataIn.readFloat();
        }
        catch (EOFException ex) {
            throw new MessageEOFException(ex.getMessage());
        }
        catch (IOException ex) {
            throw new JMSException(ex.getMessage());
        }
    }

    public double readDouble() throws JMSException {
        this.checkBodyReadable();
        try {
            return this.dataIn.readDouble();
        }
        catch (EOFException ex) {
            throw new MessageEOFException(ex.getMessage());
        }
        catch (IOException ex) {
            throw new JMSException(ex.getMessage());
        }
    }

    public String readUTF() throws JMSException {
        String result;
        this.checkBodyReadable();
        try {
            try {
                this.dataIn.mark(this.dataIn.available());
                result = this.dataIn.readUTF();
                this.dataIn.mark(0);
            }
            catch (UTFDataFormatException ex) {
                throw new MessageFormatException(ex.getMessage());
            }
            catch (EOFException ex) {
                throw new MessageEOFException(ex.getMessage());
            }
            finally {
                this.dataIn.reset();
                this.dataIn.mark(0);
            }
        }
        catch (IOException ex) {
            throw new JMSException(ex.getMessage());
        }
        return result;
    }

    public int readBytes(byte[] bytes) throws JMSException {
        this.checkBodyReadable();
        try {
            return this.dataIn.read(bytes);
        }
        catch (IOException ex) {
            throw new JMSException(ex.getMessage());
        }
    }

    public int readBytes(byte[] bytes, int length) throws JMSException {
        this.checkBodyReadable();
        try {
            return this.dataIn.read(bytes, 0, length);
        }
        catch (IOException ex) {
            throw new JMSException(ex.getMessage());
        }
    }

    public void writeBoolean(boolean value) throws JMSException {
        this.checkBodyWriteable();
        try {
            this.dataOut.writeBoolean(value);
        }
        catch (IOException ex) {
            throw new JMSException(ex.getMessage());
        }
    }

    public void writeByte(byte value) throws JMSException {
        this.checkBodyWriteable();
        try {
            this.dataOut.writeByte(value);
        }
        catch (IOException ex) {
            throw new JMSException(ex.getMessage());
        }
    }

    public void writeShort(short value) throws JMSException {
        this.checkBodyWriteable();
        try {
            this.dataOut.writeShort(value);
        }
        catch (IOException ex) {
            throw new JMSException(ex.getMessage());
        }
    }

    public void writeChar(char value) throws JMSException {
        this.checkBodyWriteable();
        try {
            this.dataOut.writeChar(value);
        }
        catch (IOException ex) {
            throw new JMSException(ex.getMessage());
        }
    }

    public void writeInt(int value) throws JMSException {
        this.checkBodyWriteable();
        try {
            this.dataOut.writeInt(value);
        }
        catch (IOException ex) {
            throw new JMSException(ex.getMessage());
        }
    }

    public void writeLong(long value) throws JMSException {
        this.checkBodyWriteable();
        try {
            this.dataOut.writeLong(value);
        }
        catch (IOException ex) {
            throw new JMSException(ex.getMessage());
        }
    }

    public void writeFloat(float value) throws JMSException {
        this.checkBodyWriteable();
        try {
            this.dataOut.writeFloat(value);
        }
        catch (IOException ex) {
            throw new JMSException(ex.getMessage());
        }
    }

    public void writeDouble(double value) throws JMSException {
        this.checkBodyWriteable();
        try {
            this.dataOut.writeDouble(value);
        }
        catch (IOException ex) {
            throw new JMSException(ex.getMessage());
        }
    }

    public void writeUTF(String value) throws JMSException {
        this.checkBodyWriteable();
        try {
            this.dataOut.writeUTF(value);
        }
        catch (IOException ex) {
            throw new JMSException(ex.getMessage());
        }
    }

    public void writeBytes(byte[] bytes) throws JMSException {
        this.checkBodyWriteable();
        try {
            this.dataOut.write(bytes);
        }
        catch (IOException ex) {
            throw new JMSException(ex.getMessage());
        }
    }

    public void writeBytes(byte[] bytes, int offset, int length) throws JMSException {
        this.checkBodyWriteable();
        try {
            this.dataOut.write(bytes, offset, length);
        }
        catch (IOException ex) {
            throw new JMSException(ex.getMessage());
        }
    }

    public void writeObject(Object value) throws JMSException {
        this.checkBodyWriteable();
        if (value == null) {
            throw new NullPointerException();
        }
        if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        }
        if (value instanceof Byte) {
            this.writeByte((Byte)value);
        }
        if (value instanceof Short) {
            this.writeShort((Short)value);
        }
        if (value instanceof Integer) {
            this.writeInt((Integer)value);
        }
        if (value instanceof Long) {
            this.writeLong((Long)value);
        }
        if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            this.writeDouble((Double)value);
        }
        if (value instanceof String) {
            this.writeUTF((String)value);
        }
        if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        }
        throw new MessageFormatException("Incorrect object type!");
    }

    void resetBody() throws JMSException {
        this.reset();
    }
}

