/*
 * Decompiled with CFR 0.152.
 */
package org.mockejb.interceptor;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;
import org.mockejb.interceptor.AspectSystem;
import org.mockejb.interceptor.AspectSystemFactory;
import org.mockejb.interceptor.Interceptor;
import org.mockejb.interceptor.InvocationContext;

public class InterceptorInvoker
implements Serializable {
    private transient AspectSystem aspectSystem = AspectSystemFactory.getAspectSystem();
    private Map context = new HashMap();

    public Object invoke(Object proxyObj, Method proxyMethod, Object targetObj, Method targetMethod, Object[] paramVals) throws Exception {
        List interceptorList = this.aspectSystem.findInterceptors(proxyMethod, targetMethod);
        interceptorList.add(new CglibMethodInvoker());
        InvocationContext invocationContext = new InvocationContext(interceptorList, proxyObj, proxyMethod, targetObj, targetMethod, paramVals, this.context);
        invocationContext.proceed();
        return invocationContext.getReturnObject();
    }

    public void setContext(String key, Object data) {
        this.context.put(key, data);
    }

    public Object getContext(String key) {
        return this.context.get(key);
    }

    public static class CglibMethodInvoker
    implements Interceptor {
        public void intercept(InvocationContext invocationContext) throws Exception {
            block5: {
                try {
                    Object returnObj;
                    Method targetMethod = invocationContext.getTargetMethod();
                    FastClass fastClass = FastClass.create(targetMethod.getDeclaringClass());
                    FastMethod fastMethod = fastClass.getMethod(targetMethod);
                    try {
                        returnObj = fastMethod.invoke(invocationContext.getTargetObject(), invocationContext.getParamVals());
                    }
                    catch (InvocationTargetException ite) {
                        throw ite.getTargetException();
                    }
                    invocationContext.setReturnObject(returnObj);
                }
                catch (Throwable throwable) {
                    if (throwable instanceof Error) {
                        throw (Error)throwable;
                    }
                    if (!(throwable instanceof Exception)) break block5;
                    throw (Exception)throwable;
                }
            }
        }
    }
}

