/*
 * Decompiled with CFR 0.152.
 */
package org.mockejb.interceptor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.mockejb.interceptor.Aspect;
import org.mockejb.interceptor.AspectSystem;
import org.mockejb.interceptor.Interceptor;
import org.mockejb.interceptor.InterceptorContainerAspect;
import org.mockejb.interceptor.Pointcut;

public class AspectSystemImpl
implements AspectSystem {
    private List aspectList = Collections.synchronizedList(new LinkedList());

    public void add(Aspect aspect) {
        this.removeIfExists(aspect);
        this.aspectList.add(aspect);
    }

    public void addFirst(Aspect aspect) {
        this.removeIfExists(aspect);
        this.aspectList.add(0, aspect);
    }

    public void add(Pointcut pointcut, Interceptor interceptor) {
        InterceptorContainerAspect aspect = new InterceptorContainerAspect(pointcut, interceptor);
        this.removeIfExists(aspect);
        this.aspectList.add(aspect);
    }

    public void addFirst(Pointcut pointcut, Interceptor interceptor) {
        InterceptorContainerAspect aspect = new InterceptorContainerAspect(pointcut, interceptor);
        this.removeIfExists(aspect);
        this.aspectList.add(0, aspect);
    }

    protected void removeIfExists(Aspect aspect) {
        this.aspectList.remove(aspect);
    }

    public List getAspectList() {
        return this.aspectList;
    }

    public void clear() {
        this.aspectList.clear();
    }

    public List findInterceptors(Method proxyMethod, Method targetMethod) {
        ArrayList<Aspect> resultList = new ArrayList<Aspect>();
        Iterator i = this.aspectList.iterator();
        while (i.hasNext()) {
            Aspect aspect = (Aspect)i.next();
            if ((proxyMethod == null || !aspect.getPointcut().matchesJointpoint(proxyMethod)) && (targetMethod == null || !aspect.getPointcut().matchesJointpoint(targetMethod))) continue;
            resultList.add(aspect);
        }
        return resultList;
    }
}

