/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.filter.mockrunner;

import javax.jms.JMSException;
import javax.jms.Message;
import org.activemq.filter.mockrunner.BinaryExpression;
import org.activemq.filter.mockrunner.Expression;

public abstract class ArithmeticExpression
extends BinaryExpression {
    protected static final int INTEGER = 1;
    protected static final int LONG = 2;
    protected static final int DOUBLE = 3;

    public ArithmeticExpression(Expression expression, Expression expression2) {
        super(expression, expression2);
    }

    public static Expression createPlus(Expression expression, Expression expression2) {
        return new ArithmeticExpression(expression, expression2){

            protected Object evaluate(Object object, Object object2) {
                if (object instanceof String) {
                    String string = (String)object;
                    String string2 = string + object2;
                    System.out.println("lvalue: " + object + " rvalue: " + object2 + " result: " + string2);
                    return string2;
                }
                if (object instanceof Number) {
                    return this.plus((Number)object, this.asNumber(object2));
                }
                throw new RuntimeException("Cannot call plus operation on: " + object + " and: " + object2);
            }

            public String getExpressionSymbol() {
                return "+";
            }
        };
    }

    public static Expression createMinus(Expression expression, Expression expression2) {
        return new ArithmeticExpression(expression, expression2){

            protected Object evaluate(Object object, Object object2) {
                if (object instanceof Number) {
                    return this.minus((Number)object, this.asNumber(object2));
                }
                throw new RuntimeException("Cannot call minus operation on: " + object + " and: " + object2);
            }

            public String getExpressionSymbol() {
                return "-";
            }
        };
    }

    public static Expression createMultiply(Expression expression, Expression expression2) {
        return new ArithmeticExpression(expression, expression2){

            protected Object evaluate(Object object, Object object2) {
                if (object instanceof Number) {
                    return this.multiply((Number)object, this.asNumber(object2));
                }
                throw new RuntimeException("Cannot call multiply operation on: " + object + " and: " + object2);
            }

            public String getExpressionSymbol() {
                return "*";
            }
        };
    }

    public static Expression createDivide(Expression expression, Expression expression2) {
        return new ArithmeticExpression(expression, expression2){

            protected Object evaluate(Object object, Object object2) {
                if (object instanceof Number) {
                    return this.divide((Number)object, this.asNumber(object2));
                }
                throw new RuntimeException("Cannot call divide operation on: " + object + " and: " + object2);
            }

            public String getExpressionSymbol() {
                return "/";
            }
        };
    }

    public static Expression createMod(Expression expression, Expression expression2) {
        return new ArithmeticExpression(expression, expression2){

            protected Object evaluate(Object object, Object object2) {
                if (object instanceof Number) {
                    return this.mod((Number)object, this.asNumber(object2));
                }
                throw new RuntimeException("Cannot call mod operation on: " + object + " and: " + object2);
            }

            public String getExpressionSymbol() {
                return "%";
            }
        };
    }

    protected Number plus(Number number, Number number2) {
        switch (this.numberType(number, number2)) {
            case 1: {
                return new Integer(number.intValue() + number2.intValue());
            }
            case 2: {
                return new Long(number.longValue() + number2.longValue());
            }
        }
        return new Double(number.doubleValue() + number2.doubleValue());
    }

    protected Number minus(Number number, Number number2) {
        switch (this.numberType(number, number2)) {
            case 1: {
                return new Integer(number.intValue() - number2.intValue());
            }
            case 2: {
                return new Long(number.longValue() - number2.longValue());
            }
        }
        return new Double(number.doubleValue() - number2.doubleValue());
    }

    protected Number multiply(Number number, Number number2) {
        switch (this.numberType(number, number2)) {
            case 1: {
                return new Integer(number.intValue() * number2.intValue());
            }
            case 2: {
                return new Long(number.longValue() * number2.longValue());
            }
        }
        return new Double(number.doubleValue() * number2.doubleValue());
    }

    protected Number divide(Number number, Number number2) {
        return new Double(number.doubleValue() / number2.doubleValue());
    }

    protected Number mod(Number number, Number number2) {
        return new Double(number.doubleValue() % number2.doubleValue());
    }

    private int numberType(Number number, Number number2) {
        if (this.isDouble(number) || this.isDouble(number2)) {
            return 3;
        }
        if (number instanceof Long || number2 instanceof Long) {
            return 2;
        }
        return 1;
    }

    private boolean isDouble(Number number) {
        return number instanceof Float || number instanceof Double;
    }

    protected Number asNumber(Object object) {
        if (object instanceof Number) {
            return (Number)object;
        }
        throw new RuntimeException("Cannot convert value: " + object + " into a number");
    }

    public Object evaluate(Message message) throws JMSException {
        Object object = this.left.evaluate(message);
        if (object == null) {
            return null;
        }
        Object object2 = this.right.evaluate(message);
        if (object2 == null) {
            return null;
        }
        return this.evaluate(object, object2);
    }

    protected abstract Object evaluate(Object var1, Object var2);
}

