/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.api.JbpmException;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.pvm.internal.model.ScopeInstanceImpl;
import org.jbpm.pvm.internal.repository.DeploymentClassLoader;
import org.jbpm.pvm.internal.repository.RepositoryCache;
import org.jbpm.pvm.internal.wire.Descriptor;
import org.jbpm.pvm.internal.wire.WireContext;
import org.jbpm.pvm.internal.wire.descriptor.ArgDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectUtil {
    private static final Log log = Log.getLog(ReflectUtil.class.getName());
    private static final Map<Class<?>, Class<?>> wrapperPrimitiveMap = ReflectUtil.createWrapperPrimitiveMap();

    private ReflectUtil() {
    }

    private static Map<Class<?>, Class<?>> createWrapperPrimitiveMap() {
        HashMap map = new HashMap();
        map.put(Boolean.class, Boolean.TYPE);
        map.put(Byte.class, Byte.TYPE);
        map.put(Character.class, Character.TYPE);
        map.put(Short.class, Short.TYPE);
        map.put(Integer.class, Integer.TYPE);
        map.put(Long.class, Long.TYPE);
        map.put(Double.class, Double.TYPE);
        map.put(Float.class, Float.TYPE);
        return map;
    }

    public static Field findField(Class<?> clazz, String fieldName) {
        return ReflectUtil.findField(clazz, fieldName, clazz);
    }

    private static Field findField(Class<?> clazz, String fieldName, Class<?> original) {
        Field field = null;
        try {
            field = clazz.getDeclaredField(fieldName);
            if (log.isTraceEnabled()) {
                log.trace("found field " + fieldName + " in " + clazz.getName());
            }
        }
        catch (NoSuchFieldException e) {
            if (clazz.getSuperclass() != null) {
                return ReflectUtil.findField(clazz.getSuperclass(), fieldName, original);
            }
            throw new JbpmException("couldn't find field '" + original.getName() + "." + fieldName + "'", e);
        }
        return field;
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes) {
        return ReflectUtil.getMethod(clazz, methodName, parameterTypes, clazz);
    }

    private static Method getMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes, Class<?> original) {
        Method method = null;
        try {
            method = clazz.getDeclaredMethod(methodName, parameterTypes);
            if (log.isTraceEnabled()) {
                log.trace("found method " + clazz.getName() + "." + methodName + "(" + Arrays.toString(parameterTypes) + ")");
            }
        }
        catch (NoSuchMethodException e) {
            if (clazz.getSuperclass() != null) {
                return ReflectUtil.getMethod(clazz.getSuperclass(), methodName, parameterTypes, original);
            }
            throw new JbpmException("couldn't find method '" + original.getName() + "." + methodName + "(" + ReflectUtil.getParameterTypesText(parameterTypes) + ")'", e);
        }
        return method;
    }

    private static String getParameterTypesText(Class<?>[] parameterTypes) {
        if (parameterTypes == null) {
            return "";
        }
        StringBuilder parameterTypesText = new StringBuilder();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            parameterTypesText.append(parameterType.getName());
            if (i == parameterTypes.length - 1) continue;
            parameterTypesText.append(", ");
        }
        return parameterTypesText.toString();
    }

    public static <T> T newInstance(Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("cannot create new instance without class");
        }
        try {
            return ReflectUtil.newInstance(clazz.getConstructor(new Class[0]), new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("cannot instantiate class without default constructor");
        }
    }

    public static <T> T newInstance(Constructor<T> constructor, Object ... args) {
        if (constructor == null) {
            throw new IllegalArgumentException("cannot create new instance without constructor");
        }
        Class<T> clazz = constructor.getDeclaringClass();
        if (log.isTraceEnabled()) {
            log.trace("creating new instance for " + clazz + " with args " + Arrays.toString(args));
        }
        if (!constructor.isAccessible()) {
            if (log.isTraceEnabled()) {
                log.trace("making constructor accessible");
            }
            constructor.setAccessible(true);
        }
        try {
            return constructor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new JbpmException("failed to instantiate " + clazz, e);
        }
        catch (IllegalAccessException e) {
            throw new JbpmException(ReflectUtil.class + " has no access to " + constructor, e);
        }
        catch (InvocationTargetException e) {
            throw new JbpmException(constructor + " threw exception", e.getCause());
        }
    }

    public static Object get(Field field, Object object) {
        if (field == null) {
            throw new NullPointerException("field is null");
        }
        try {
            Object value = field.get(object);
            if (log.isTraceEnabled()) {
                log.trace("got value '" + value + "' from field '" + field.getName() + "'");
            }
            return value;
        }
        catch (Exception e) {
            throw new JbpmException("couldn't get '" + field.getName() + "'", e);
        }
    }

    public static void set(Field field, Object object, Object value) {
        if (field == null) {
            throw new NullPointerException("field is null");
        }
        try {
            if (log.isTraceEnabled()) {
                log.trace("setting field '" + field.getName() + "' to value '" + value + "'");
            }
            if (!field.isAccessible()) {
                if (log.isTraceEnabled()) {
                    log.trace("making field accessible");
                }
                field.setAccessible(true);
            }
            field.set(object, value);
        }
        catch (Exception e) {
            throw new JbpmException("couldn't set '" + field.getName() + "' to '" + value + "'", e);
        }
    }

    public static Object invoke(Method method, Object target, Object[] args) {
        if (method == null) {
            throw new JbpmException("method is null");
        }
        try {
            if (log.isTraceEnabled()) {
                log.trace("invoking '" + method.getName() + "' on '" + target + "' with " + Arrays.toString(args));
            }
            if (!method.isAccessible()) {
                log.trace("making method accessible");
                method.setAccessible(true);
            }
            return method.invoke(target, args);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            throw new JbpmException("couldn't invoke '" + method.getName() + "' with " + Arrays.toString(args) + " on " + target + ": " + targetException.getMessage(), targetException);
        }
        catch (Exception e) {
            throw new JbpmException("couldn't invoke '" + method.getName() + "' with " + Arrays.toString(args) + " on " + target + ": " + e.getMessage(), e);
        }
    }

    public static Method findMethod(Class<?> clazz, String methodName, List<ArgDescriptor> argDescriptors, Object[] args) {
        if (log.isTraceEnabled()) {
            log.trace("searching for method " + methodName + " in " + clazz.getName());
        }
        Method[] candidates = clazz.getDeclaredMethods();
        for (int i = 0; i < candidates.length; ++i) {
            Method candidate = candidates[i];
            if (!candidate.getName().equals(methodName) || !ReflectUtil.isArgumentMatch(candidate.getParameterTypes(), argDescriptors, args)) continue;
            if (log.isTraceEnabled() && log.isTraceEnabled()) {
                log.trace("found matching method " + clazz.getName() + "." + methodName);
            }
            return candidate;
        }
        if (clazz.getSuperclass() != null) {
            return ReflectUtil.findMethod(clazz.getSuperclass(), methodName, argDescriptors, args);
        }
        return null;
    }

    public static Constructor<?> findConstructor(Class<?> clazz, List<ArgDescriptor> argDescriptors, Object[] args) {
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            if (!ReflectUtil.isArgumentMatch(constructors[i].getParameterTypes(), argDescriptors, args)) continue;
            return constructors[i];
        }
        return null;
    }

    public static boolean isArgumentMatch(Class<?>[] parameterTypes, List<ArgDescriptor> argDescriptors, Object[] args) {
        int nbrOfParameterTypes;
        int nbrOfArgs = args != null ? args.length : 0;
        int n = nbrOfParameterTypes = parameterTypes != null ? parameterTypes.length : 0;
        if (nbrOfArgs != nbrOfParameterTypes) {
            return false;
        }
        if (nbrOfArgs == 0) {
            return true;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            Object arg;
            String argTypeName;
            Class<?> parameterType = parameterTypes[i];
            if (!(argDescriptors == null || (argTypeName = argDescriptors.get(i).getTypeName()) == null ? !ReflectUtil.isAssignable(parameterType, arg = args[i]) : !parameterType.getName().equals(argTypeName))) continue;
            return false;
        }
        return true;
    }

    private static boolean isAssignable(Class<?> type, Object value) {
        if (value == null) {
            return !type.isPrimitive();
        }
        if (type.isPrimitive()) {
            Class<?> valueType = ReflectUtil.wrapperToPrimitive(value.getClass());
            if (null == valueType) {
                return false;
            }
            if (type == valueType) {
                return true;
            }
            if (Integer.TYPE == valueType) {
                return Long.TYPE == type || Float.TYPE == type || Double.TYPE == type;
            }
            if (Long.TYPE == valueType) {
                return Float.TYPE == type || Double.TYPE == type;
            }
            if (Boolean.TYPE == valueType) {
                return false;
            }
            if (Double.TYPE == valueType) {
                return false;
            }
            if (Float.TYPE == valueType) {
                return Double.TYPE == type;
            }
            if (Character.TYPE == valueType) {
                return Integer.TYPE == type || Long.TYPE == type || Float.TYPE == type || Double.TYPE == type;
            }
            if (Short.TYPE == valueType) {
                return Integer.TYPE == type || Long.TYPE == type || Float.TYPE == type || Double.TYPE == type;
            }
            if (Byte.TYPE == valueType) {
                return Short.TYPE == type || Integer.TYPE == type || Long.TYPE == type || Float.TYPE == type || Double.TYPE == type;
            }
            return false;
        }
        return type.isInstance(value);
    }

    private static Class<?> wrapperToPrimitive(Class<?> cls) {
        return wrapperPrimitiveMap.get(cls);
    }

    public static String getSignature(String methodName, List<ArgDescriptor> argDescriptors, Object[] args) {
        String signature = methodName + "(";
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                ArgDescriptor argDescriptor;
                String argType = null;
                if (argDescriptors != null && (argDescriptor = argDescriptors.get(i)) != null && argDescriptor.getTypeName() != null) {
                    argType = argDescriptor.getTypeName();
                }
                if (argType == null && args[i] != null) {
                    argType = args[i].getClass().getName();
                }
                signature = signature + argType;
                if (i >= args.length - 1) continue;
                signature = signature + ", ";
            }
        }
        signature = signature + ")";
        return signature;
    }

    public static ClassLoader installDeploymentClassLoader(ProcessDefinitionImpl processDefinition) {
        String deploymentId = processDefinition.getDeploymentId();
        if (deploymentId == null) {
            return null;
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader original = currentThread.getContextClassLoader();
        RepositoryCache repositoryCache = EnvironmentImpl.getFromCurrent(RepositoryCache.class);
        DeploymentClassLoader deploymentClassLoader = repositoryCache.getDeploymentClassLoader(deploymentId, original);
        if (deploymentClassLoader == null) {
            deploymentClassLoader = new DeploymentClassLoader(original, deploymentId);
            repositoryCache.setDeploymentClassLoader(deploymentId, original, deploymentClassLoader);
        }
        currentThread.setContextClassLoader(deploymentClassLoader);
        return original;
    }

    public static void uninstallDeploymentClassLoader(ClassLoader original) {
        if (original != null) {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object instantiateUserCode(Descriptor descriptor, ProcessDefinitionImpl processDefinition, ScopeInstanceImpl scopeInstance) {
        ClassLoader classLoader = ReflectUtil.installDeploymentClassLoader(processDefinition);
        try {
            Object object = WireContext.create(descriptor, scopeInstance);
            return object;
        }
        finally {
            ReflectUtil.uninstallDeploymentClassLoader(classLoader);
        }
    }

    public static Class<?> classForName(String name) throws ClassNotFoundException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            try {
                return Class.forName(name, true, contextClassLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return Class.forName(name);
    }
}

