/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jbpm.internal.log.Log;

public class IoUtil {
    public static final int BUFFERSIZE = 4096;
    private static final Log log = Log.getLog(IoUtil.class.getName());

    private IoUtil() {
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IoUtil.transfer(in, out);
        return out.toByteArray();
    }

    public static void close(Closeable closeable) {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug("failed to close stream", e);
                }
            }
        }
    }

    public static long transfer(InputStream in, OutputStream out) throws IOException {
        int count;
        long total = 0L;
        byte[] buffer = new byte[4096];
        while ((count = in.read(buffer)) != -1) {
            out.write(buffer, 0, count);
            total += (long)count;
        }
        return total;
    }
}

