/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.repository;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jbpm.api.JbpmException;
import org.jbpm.api.NewDeployment;
import org.jbpm.pvm.internal.cmd.CommandService;
import org.jbpm.pvm.internal.cmd.DeployCmd;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.id.DbidGenerator;
import org.jbpm.pvm.internal.lob.Lob;
import org.jbpm.pvm.internal.repository.DeploymentProperty;
import org.jbpm.pvm.internal.repository.RepositoryCache;
import org.jbpm.pvm.internal.repository.RepositorySessionImpl;
import org.jbpm.pvm.internal.stream.ByteArrayStreamInput;
import org.jbpm.pvm.internal.stream.FileStreamInput;
import org.jbpm.pvm.internal.stream.InputStreamInput;
import org.jbpm.pvm.internal.stream.ResourceStreamInput;
import org.jbpm.pvm.internal.stream.StreamInput;
import org.jbpm.pvm.internal.stream.StringStreamInput;
import org.jbpm.pvm.internal.stream.UrlStreamInput;
import org.jbpm.pvm.internal.util.IoUtil;
import org.jbpm.pvm.internal.xml.ProblemList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentImpl
extends ProblemList
implements NewDeployment {
    private static final long serialVersionUID = 1L;
    public static final String KEY_PROCESS_LANGUAGE_ID = "langid";
    public static final String KEY_PROCESS_DEFINITION_ID = "pdid";
    public static final String KEY_PROCESS_DEFINITION_KEY = "pdkey";
    public static final String KEY_PROCESS_DEFINITION_VERSION = "pdversion";
    protected long dbid;
    protected String name;
    protected long timestamp;
    protected String state = "active";
    protected Map<String, Lob> resources;
    protected CommandService commandService;
    protected Map<String, Object> objects;
    protected Set<DeploymentProperty> objectProperties;

    public DeploymentImpl() {
    }

    public DeploymentImpl(CommandService commandService) {
        this.commandService = commandService;
    }

    public String toString() {
        return "deployment(" + this.dbid + ")";
    }

    @Override
    public String deploy() {
        return this.commandService.execute(new DeployCmd(this));
    }

    @Override
    public NewDeployment addResourceFromClasspath(String resourceName) {
        this.addResourceFromStreamInput(resourceName, new ResourceStreamInput(resourceName));
        return this;
    }

    @Override
    public NewDeployment addResourceFromString(String resourceName, String text) {
        this.addResourceFromStreamInput(resourceName, new StringStreamInput(text));
        return this;
    }

    @Override
    public NewDeployment addResourcesFromZipInputStream(ZipInputStream zipInputStream) {
        try {
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                String entryName = zipEntry.getName();
                byte[] bytes = IoUtil.readBytes(zipInputStream);
                if (bytes != null) {
                    this.addResourceFromStreamInput(entryName, new ByteArrayStreamInput(bytes));
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        catch (IOException e) {
            throw new JbpmException("couldn't read zip archive", e);
        }
        finally {
            IoUtil.close(zipInputStream);
        }
        return this;
    }

    @Override
    public NewDeployment addResourceFromInputStream(String resourceName, InputStream inputStream) {
        this.addResourceFromStreamInput(resourceName, new InputStreamInput(inputStream));
        return this;
    }

    @Override
    public NewDeployment addResourceFromUrl(URL url) {
        this.addResourceFromStreamInput(url.toString(), new UrlStreamInput(url));
        return this;
    }

    @Override
    public NewDeployment addResourceFromFile(File file) {
        this.addResourceFromStreamInput(file.getPath(), new FileStreamInput(file));
        return this;
    }

    public NewDeployment addResourceFromStreamInput(String name, StreamInput streamInput) {
        if (this.resources == null) {
            this.resources = new HashMap<String, Lob>();
        }
        InputStream inputStream = streamInput.openStream();
        try {
            byte[] bytes = IoUtil.readBytes(inputStream);
            Lob lob = new Lob(bytes, false);
            this.resources.put(name, lob);
        }
        catch (IOException e) {
            throw new JbpmException("couldn't read from " + name, e);
        }
        finally {
            IoUtil.close(inputStream);
        }
        return this;
    }

    public Set<String> getResourceNames() {
        if (this.resources == null) {
            return Collections.emptySet();
        }
        return this.resources.keySet();
    }

    public void initResourceLobDbids() {
        if (this.resources != null) {
            for (Lob resource : this.resources.values()) {
                long resourceDbid = DbidGenerator.getDbidGenerator().getNextId();
                resource.setDbid(resourceDbid);
            }
        }
    }

    public byte[] getBytes(String resourceName) {
        Lob lob;
        if (this.resources != null && (lob = this.resources.get(resourceName)) != null) {
            return lob.extractBytes();
        }
        return null;
    }

    public void addObject(String objectName, Object object) {
        if (this.objects == null) {
            this.objects = new HashMap<String, Object>();
        }
        this.objects.put(objectName, object);
    }

    public void setProcessDefinitionId(String processDefinitionName, String processDefinitionId) {
        this.setObjectProperty(processDefinitionName, KEY_PROCESS_DEFINITION_ID, processDefinitionId);
    }

    public String getProcessDefinitionId(String processDefinitionName) {
        return (String)this.getObjectProperty(processDefinitionName, KEY_PROCESS_DEFINITION_ID);
    }

    public void setProcessDefinitionKey(String processDefinitionName, String processDefinitionKey) {
        this.setObjectProperty(processDefinitionName, KEY_PROCESS_DEFINITION_KEY, processDefinitionKey);
    }

    public String getProcessDefinitionKey(String processDefinitionName) {
        return (String)this.getObjectProperty(processDefinitionName, KEY_PROCESS_DEFINITION_KEY);
    }

    public void setProcessDefinitionVersion(String processDefinitionName, Long processDefinitionVersion) {
        this.setObjectProperty(processDefinitionName, KEY_PROCESS_DEFINITION_VERSION, processDefinitionVersion);
    }

    public Long getProcessDefinitionVersion(String processDefinitionName) {
        return (Long)this.getObjectProperty(processDefinitionName, KEY_PROCESS_DEFINITION_VERSION);
    }

    public String getProcessLanguageId(String processDefinitionName) {
        return (String)this.getObjectProperty(processDefinitionName, KEY_PROCESS_LANGUAGE_ID);
    }

    public void setProcessLanguageId(String processDefinitionName, String processLanguageId) {
        this.setObjectProperty(processDefinitionName, KEY_PROCESS_LANGUAGE_ID, processLanguageId);
    }

    public void setObjectProperty(String objectName, String key, Object value) {
        if (this.objectProperties == null) {
            this.objectProperties = new HashSet<DeploymentProperty>();
        }
        DeploymentProperty deploymentProperty = new DeploymentProperty(this, objectName, key);
        deploymentProperty.setValue(value);
        this.objectProperties.add(deploymentProperty);
    }

    public Object removeObjectProperty(String objectName, String key) {
        if (this.objectProperties != null) {
            for (DeploymentProperty deploymentProperty : this.objectProperties) {
                if (!deploymentProperty.getObjectName().equals(objectName) || !deploymentProperty.getKey().equals(key)) continue;
                Object value = deploymentProperty.getValue();
                this.objectProperties.remove(deploymentProperty);
                return value;
            }
        }
        return null;
    }

    public Object getObjectProperty(String objectName, String key) {
        if (this.objectProperties != null) {
            for (DeploymentProperty deploymentProperty : this.objectProperties) {
                if (!deploymentProperty.getObjectName().equals(objectName) || !deploymentProperty.getKey().equals(key)) continue;
                return deploymentProperty.getValue();
            }
        }
        return null;
    }

    public Set<String> getProcessDefinitionIds() {
        HashSet<String> processDefinitionIds = new HashSet<String>();
        if (this.objectProperties != null) {
            for (DeploymentProperty deploymentProperty : this.objectProperties) {
                if (!KEY_PROCESS_DEFINITION_ID.equals(deploymentProperty.getKey())) continue;
                String processDefinitionId = deploymentProperty.getStringValue();
                processDefinitionIds.add(processDefinitionId);
            }
        }
        return processDefinitionIds;
    }

    public boolean hasObjectProperties(String objectName) {
        if (this.objectProperties != null) {
            for (DeploymentProperty deploymentProperty : this.objectProperties) {
                if (!deploymentProperty.getObjectName().equals(objectName) || !KEY_PROCESS_DEFINITION_ID.equals(deploymentProperty.getKey())) continue;
                return true;
            }
        }
        return false;
    }

    public void suspend() {
        if (this.isSuspended()) {
            throw new JbpmException("deployment is already suspended");
        }
        this.state = "suspended";
        RepositorySessionImpl repositorySession = EnvironmentImpl.getFromCurrent(RepositorySessionImpl.class);
        repositorySession.cascadeDeploymentSuspend(this);
        RepositoryCache repositoryCache = EnvironmentImpl.getFromCurrent(RepositoryCache.class);
        repositoryCache.remove(Long.toString(this.dbid));
    }

    public void resume() {
        if (!this.isSuspended()) {
            throw new JbpmException("deployment is not suspended");
        }
        this.state = "active";
        RepositorySessionImpl repositorySession = EnvironmentImpl.getFromCurrent(RepositorySessionImpl.class);
        repositorySession.cascadeDeploymentResume(this);
        RepositoryCache repositoryCache = EnvironmentImpl.getFromCurrent(RepositoryCache.class);
        repositoryCache.remove(Long.toString(this.dbid));
    }

    public boolean isSuspended() {
        return "suspended".equals(this.state);
    }

    protected Object writeReplace() throws ObjectStreamException {
        this.commandService = null;
        return this;
    }

    @Override
    public String getId() {
        return Long.toString(this.dbid);
    }

    public long getDbid() {
        return this.dbid;
    }

    public Map<String, Object> getObjects() {
        return this.objects;
    }

    public Set<DeploymentProperty> getObjectProperties() {
        return this.objectProperties;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DeploymentImpl setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public DeploymentImpl setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Override
    public String getState() {
        return this.state;
    }

    public void setDbid(long dbid) {
        this.dbid = dbid;
    }
}

