/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.query;

import java.util.Date;
import java.util.List;
import org.hibernate.Query;
import org.jbpm.api.JbpmException;
import org.jbpm.api.history.HistoryActivityInstance;
import org.jbpm.api.history.HistoryActivityInstanceQuery;
import org.jbpm.pvm.internal.history.model.HistoryActivityInstanceImpl;
import org.jbpm.pvm.internal.query.AbstractQuery;
import org.jbpm.pvm.internal.query.Page;
import org.jbpm.pvm.internal.util.CollectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryActivityInstanceQueryImpl
extends AbstractQuery
implements HistoryActivityInstanceQuery {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;
    protected Long tookLessThen;
    protected Long tookLongerThen;
    protected Date startedBefore;
    protected Date startedAfter;
    protected String executionId;
    protected String processInstanceId;
    protected String activityName;

    @Override
    public String hql() {
        StringBuilder hql = new StringBuilder();
        hql.append("select ");
        if (this.count) {
            hql.append("count(hai) ");
        } else {
            hql.append("hai ");
        }
        hql.append("from ");
        hql.append(HistoryActivityInstanceImpl.class.getName());
        hql.append(" as hai ");
        if (this.processDefinitionId != null) {
            this.appendWhereClause(" hai.historyProcessInstance.processDefinitionId = '" + this.processDefinitionId + "' ", hql);
        }
        if (this.tookLessThen != null) {
            this.appendWhereClause(" hai.duration < :tookLessThen ", hql);
        }
        if (this.tookLongerThen != null) {
            this.appendWhereClause(" hai.duration > :tookLongerThen ", hql);
        }
        if (this.startedBefore != null) {
            this.appendWhereClause(" hai.startTime < :startedBefore ", hql);
        }
        if (this.startedAfter != null) {
            this.appendWhereClause(" hai.startTime > :startedAfter ", hql);
        }
        if (this.processInstanceId != null) {
            this.appendWhereClause(" hai.historyProcessInstance.processInstanceId = '" + this.processInstanceId + "'", hql);
        }
        if (this.executionId != null) {
            this.appendWhereClause(" hai.executionId = '" + this.executionId + "'", hql);
        }
        if (this.activityName != null) {
            this.appendWhereClause(" hai.activityName = '" + this.activityName + "'", hql);
        }
        this.appendOrderByClause(hql);
        return hql.toString();
    }

    @Override
    protected void applyParameters(Query query) {
        if (this.tookLessThen != null) {
            query.setLong("tookLessThen", this.tookLessThen.longValue());
        }
        if (this.tookLongerThen != null) {
            query.setLong("tookLongerThen", this.tookLongerThen.longValue());
        }
        if (this.startedBefore != null) {
            query.setTimestamp("startedBefore", this.startedBefore);
        }
        if (this.startedAfter != null) {
            query.setTimestamp("startedAfter", this.startedAfter);
        }
    }

    @Override
    public List<HistoryActivityInstance> list() {
        return CollectionUtil.checkList(this.untypedList(), HistoryActivityInstance.class);
    }

    @Override
    public HistoryActivityInstance uniqueResult() {
        return (HistoryActivityInstance)this.untypedUniqueResult();
    }

    @Override
    public HistoryActivityInstanceQuery activityName(String activityName) {
        this.activityName = activityName;
        return this;
    }

    @Override
    public HistoryActivityInstanceQuery executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    @Override
    public HistoryActivityInstanceQuery processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public HistoryActivityInstanceQuery orderAsc(String property) {
        this.addOrderByClause("hai." + property + " asc");
        return this;
    }

    @Override
    public HistoryActivityInstanceQuery orderDesc(String property) {
        this.addOrderByClause("hai." + property + " desc");
        return this;
    }

    @Override
    public HistoryActivityInstanceQuery page(int firstResult, int maxResults) {
        this.page = new Page(firstResult, maxResults);
        return this;
    }

    @Override
    public HistoryActivityInstanceQuery processDefinitionId(String processDefinitionId) {
        if (processDefinitionId == null) {
            throw new JbpmException("processInstanceId is null");
        }
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public HistoryActivityInstanceQuery startedAfter(Date time) {
        this.startedAfter = time;
        return this;
    }

    @Override
    public HistoryActivityInstanceQuery startedBefore(Date time) {
        this.startedBefore = time;
        return this;
    }

    @Override
    public HistoryActivityInstanceQuery tookLessThen(long durationInMillis) {
        this.tookLessThen = durationInMillis;
        return this;
    }

    @Override
    public HistoryActivityInstanceQuery tookLongerThen(long durationInMillis) {
        this.tookLongerThen = durationInMillis;
        return this;
    }
}

