/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.cmd;

import org.jbpm.api.cmd.Environment;
import org.jbpm.pvm.internal.cmd.AbstractCommand;
import org.jbpm.pvm.internal.history.HistoryEvent;
import org.jbpm.pvm.internal.history.events.TaskCreated;
import org.jbpm.pvm.internal.history.events.TaskUpdated;
import org.jbpm.pvm.internal.session.DbSession;
import org.jbpm.pvm.internal.task.TaskImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveTaskCmd
extends AbstractCommand<String> {
    private static final long serialVersionUID = 1L;
    protected TaskImpl task;

    public SaveTaskCmd(TaskImpl task) {
        this.task = task;
    }

    @Override
    public String execute(Environment environment) throws Exception {
        DbSession dbSession = environment.get(DbSession.class);
        if (this.task.isNew()) {
            if (this.task.getSuperTaskDbid() != null) {
                TaskImpl parentTask = dbSession.get(TaskImpl.class, this.task.getSuperTaskDbid());
                parentTask.addSubTask(this.task);
                this.task.setSuperTaskDbid(null);
            }
            dbSession.save(this.task);
            HistoryEvent.fire(new TaskCreated(this.task));
        } else {
            dbSession.update(this.task);
            HistoryEvent.fire(new TaskUpdated(this.task));
        }
        return this.task.getId();
    }
}

