/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.cmd;

import org.jbpm.api.JbpmException;
import org.jbpm.api.activity.ActivityBehaviour;
import org.jbpm.api.cmd.Command;
import org.jbpm.api.cmd.Environment;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.pvm.internal.session.RepositorySession;
import org.jbpm.pvm.internal.task.FormBehaviour;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetStartFormResourceNameCmd
implements Command<String> {
    private static final long serialVersionUID = 1L;
    String processDefinitionId;
    String activityName;

    public GetStartFormResourceNameCmd(String processDefinitionId, String activityName) {
        if (processDefinitionId == null) {
            throw new JbpmException("processDefinitionId is null");
        }
        this.processDefinitionId = processDefinitionId;
        this.activityName = activityName;
    }

    @Override
    public String execute(Environment environment) {
        RepositorySession repositorySession = environment.get(RepositorySession.class);
        ProcessDefinitionImpl processDefinition = repositorySession.findProcessDefinitionById(this.processDefinitionId);
        ActivityImpl activity = processDefinition.getActivity(this.activityName);
        ActivityBehaviour behaviour = activity.getActivityBehaviour();
        if (behaviour instanceof FormBehaviour) {
            return ((FormBehaviour)((Object)behaviour)).getFormResourceName();
        }
        return null;
    }
}

